$(document).ready(function() {
    $('#form-cadastro-sorteio').formValidation({
            framework: 'bootstrap',
            icon: {
                valid: 'glyphicon glyphicon-ok',
                invalid: 'glyphicon glyphicon-remove',
                validating: 'glyphicon glyphicon-refresh'
            },
            fields: {
                'nome': {
                    validators: {
                        notEmpty: {
                            message: 'O nome é obrigatório e não pode ser vazio.'
                        },
                        stringLength: {
                            min: 10,
                            max: 100,
                            message: 'O nome deve estar entre 10 e 100 caracteres.'
                        }
                    }
                },
                'email': {
                    validators: {
                        notEmpty: {
                            message: 'O email é obrigatório e não pode ser vazio.'
                        },
                        stringLength: {
                            min: 10,
                            max: 100,
                            message: 'O email deve estar entre 10 e 100 caracteres.'
                        },
                        emailAddress: {
                            message: 'O email digitado não é válido.'
                        }
                    }
                },
                'telefone': {
                    validators: {
                        notEmpty: {
                            message: 'O telefone é obrigatório e não pode ser vazio.'
                        },
                        stringLength: {
                            min: 10,
                            max: 100,
                            message: 'O telefone deve estar entre 10 e 100 caracteres.'
                        }
                    }
                },
            }
        })
        /*
        .on('success.form.fv', function(e) {
            //e.preventDefault();
            var $form = $(e.target);
            $form.formValidation('disableSubmitButtons', false);
        }).on('err.form.fv', function(e, data) {
            //e.preventDefault();
            var $form = $(e.target);
            $form.formValidation('disableSubmitButtons', false);
        })
        */
        .find('#telefone').mask('(99) 99999-9999');
    $('#btn-cadastrar').click(function() {});
});