<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Analise_model extends CI_Model {

  public function buscarMembros() {
    return $this->db->get('membro')->result_object();
  }

  public function buscarNomeMembroPeloId($idMembro) {
    $this->db->where('id', $idMembro);
    return $this->db->get('membro')->result_object();
  }

  public function buscarIdMembroPeloNome($nome) {
    $this->db->where('nome', $nome);
    $query = "select * from membro where nome = '" . $nome . "';";
    return $this->db->query($query)->result_object();
  }

  public function buscarAnalises() {
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarPontuacaoGeral($idMembro) {
    $this->db->select('pontuacao_geral');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarReferencias1($idMembro) {
    $this->db->select('referencias1, mes_analisado');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarReferencias1ComFiltro($idMembro, $dataInicio, $dataFim) {
    $this->db->select('referencias1, mes_analisado');
    $this->db->where('id_membro', $idMembro);
    $this->db->where("mes_analisado BETWEEN '$dataInicio' AND '$dataFim'");
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarReferencias2($idMembro) {
    $this->db->select('referencias2');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarUnsAUns1($idMembro) {
    $this->db->select('uns_a_uns1');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

 public function buscarUnsAUns1ComFiltro($idMembro, $dataInicio, $dataFim) {
    $this->db->select('uns_a_uns1');
    $this->db->where('id_membro', $idMembro);
    $this->db->where("mes_analisado BETWEEN '$dataInicio' AND '$dataFim'");
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarUnsAUns2($idMembro) {
    $this->db->select('uns_a_uns2');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarVisitas1($idMembro) {
    $this->db->select('visitas1');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarVisitas1ComFiltro($idMembro, $dataInicio, $dataFim) {
    $this->db->select('visitas1');
    $this->db->where('id_membro', $idMembro);
    $this->db->where("mes_analisado BETWEEN '$dataInicio' AND '$dataFim'");
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarVisitas2($idMembro) {
    $this->db->select('visitas2');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarFormacoes1($idMembro) {
    $this->db->select('formacoes1');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarFormacoes1ComFiltro($idMembro, $dataInicio, $dataFim) {
    $this->db->select('formacoes1');
    $this->db->where('id_membro', $idMembro);
    $this->db->where("mes_analisado BETWEEN '$dataInicio' AND '$dataFim'");
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarFormacoes2($idMembro) {
    $this->db->select('formacoes2');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarObrigados1($idMembro) {
    $this->db->select('obrigado1');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarObrigados1ComFiltro($idMembro, $dataInicio, $dataFim) {
    $this->db->select('obrigado1');
    $this->db->where('id_membro', $idMembro);
    $this->db->where("mes_analisado BETWEEN '$dataInicio' AND '$dataFim'");
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarObrigados2($idMembro) {
    $this->db->select('obrigado2');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarTestemunhos1($idMembro) {
    $this->db->select('testemunhos1');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarTestemunhos1ComFiltro($idMembro, $dataInicio, $dataFim) {
    $this->db->select('testemunhos1');
    $this->db->where('id_membro', $idMembro);
    $this->db->where("mes_analisado BETWEEN '$dataInicio' AND '$dataFim'");
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarTestemunhos2($idMembro) {
    $this->db->select('testemunhos2');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarFaltas1($idMembro) {
    $this->db->select('faltas1');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarFaltas1ComFiltro($idMembro, $dataInicio, $dataFim) {
    $this->db->select('faltas1');
    $this->db->where('id_membro', $idMembro);
    $this->db->where("mes_analisado BETWEEN '$dataInicio' AND '$dataFim'");
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarFaltas2($idMembro) {
    $this->db->select('faltas2');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarAtrasos1($idMembro) {
    $this->db->select('atrasos1');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarAtrasos1ComFiltro($idMembro, $dataInicio, $dataFim) {
    $this->db->select('atrasos1');
    $this->db->where('id_membro', $idMembro);
    $this->db->where("mes_analisado BETWEEN '$dataInicio' AND '$dataFim'");
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarAtrasos2($idMembro) {
    $this->db->select('atrasos2');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by("mes_analisado", "asc");
    return $this->db->get('analise')->result_object();
  }

  public function buscarPontuacoes($idMembro) {
    $this->db->select('pontuacao_geral');
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by('mes_analisado', 'asc');
    return $this->db->get('analise')->result_object();
  }

  public function buscarPontuacoesComFiltro($idMembro, $dataInicio, $dataFim) {
    $this->db->select('pontuacao_geral');
    $this->db->where('id_membro', $idMembro);
    $this->db->where("mes_analisado BETWEEN '$dataInicio' AND '$dataFim'");
    $this->db->order_by('mes_analisado', 'asc');
    return $this->db->get('analise')->result_object();
  }

  public function buscarDataFiltroInicial($idMembro) {
    $this->db->select('mes_analisado');
    $this->db->distinct();
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by('mes_analisado', 'asc');
    $resultado    = $this->db->get('analise');
    $resultado    = $resultado->result_object();
    /*
    $qtde         = $resultado->num_rows();
    $divisao      = $qtde / 2;
    $divisaoExata = ($qtde % 2 == 0) ? true : false;
    $resultado    = $resultado->result_object();
    if ($divisaoExata == false) {
      for ($x = floor($divisao); $x < $qtde; $x++) {
        unset($resultado[$x]);
      }
    } else {
      for ($x = $divisao; $x < $qtde; $x++) {
        unset($resultado[$x]);
      }
    }
    */
    return $resultado;
  }

  public function buscarDataFiltroFinal($idMembro) {
    $this->db->select('mes_analisado');
    $this->db->distinct();
    $this->db->where('id_membro', $idMembro);
    $this->db->order_by('mes_analisado', 'desc');
    $resultado    = $this->db->get('analise');
    $resultado    = $resultado->result_object();
    /*
    $qtde         = $resultado->num_rows();
    $divisao      = $qtde / 2;
    $divisaoExata = ($qtde % 2 == 0) ? true : false;
    $resultado    = $resultado->result_object();
    if ($divisaoExata == false) {
      for ($x = 0; $x < floor($divisao); $x++) {
        unset($resultado[$x]);
      }
    } else {
      for ($x = 0; $x < $divisao; $x++) {
        unset($resultado[$x]);
      }
    }
    */
    /*
    header("Content-Type: application/json");
    echo json_encode(array(
      'resultado'    => $resultado,
      'divisao'      => $divisao,
      'divisaoExata' => $divisaoExata,
      'qtde'         => $qtde)); //die();
      */
    return $resultado;
  }

}
