<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usuario extends CI_Controller {

  public function __construct() {
    parent::__construct();
    if (!$this->session->userdata('usuario_logado')) {
      $this->session->set_flashdata('erro', 'Por favor, efetue o login para acessar!');
      redirect('auth/login', 'refresh');
    }
    $this->load->model('Usuario_model');
    $this->load->model('Analise_model');
  }

  public function index() {

  }

  public function perfil() {
    $this->load->view('usuario/perfil');
  }

  public function analiseperfis() {
    $membros = $this->Usuario_model->listarTodosMembros();
    $dados   = array('membros' => $membros);
    $this->load->view('usuario/analiseperfis', $dados);
  }

  public function uploadpdf() {
    $this->load->model('Pdfanalise_model');
    $dados = array(
      'pdfs_analise' => $this->Pdfanalise_model->buscarPdfsAnalise(),
    );
    $this->load->view('usuario/uploadpdf', $dados);
  }

  public function analiseperfil() {
    $idUsuario = $this->uri->segment(3);
    $this->load->helper('conversordata');
    $dados = array(
      'nome'                => $this->Analise_model->buscarNomeMembroPeloId($idUsuario),
      'pontuacoes'          => $this->Analise_model->buscarPontuacoes($idUsuario),
      'membros'             => $this->Analise_model->buscarMembros(),
      'referencias1'        => $this->Analise_model->buscarReferencias1($idUsuario),
      'uns_a_uns1'          => $this->Analise_model->buscarUnsAUns1($idUsuario),
      'visitas1'            => $this->Analise_model->buscarVisitas1($idUsuario),
      'formacoes1'          => $this->Analise_model->buscarFormacoes1($idUsuario),
      'obrigado1'           => $this->Analise_model->buscarObrigados1($idUsuario),
      'testemunhos1'        => $this->Analise_model->buscarTestemunhos1($idUsuario),
      'faltas1'             => $this->Analise_model->buscarFaltas1($idUsuario),
      'atrasos1'            => $this->Analise_model->buscarAtrasos1($idUsuario),
      'error'               => '',
      'data_filtro_inicial' => $this->Analise_model->buscarDataFiltroInicial($idUsuario),
      'data_filtro_final'   => $this->Analise_model->buscarDataFiltroFinal($idUsuario),
    );
    $this->load->view('usuario/analiseperfis', $dados);
  }

  public function analiseperfilcomfiltro() {
    $idUsuario  = $this->input->post('idUsuario');
    $dataInicio = $this->input->post('dataInicio');
    $dataFim    = $this->input->post('dataFim');
    $this->load->helper('conversordata');
    $dados = array(
      'nome'                => $this->Analise_model->buscarNomeMembroPeloId($idUsuario),
      'pontuacoes'          => $this->Analise_model->buscarPontuacoesComFiltro($idUsuario, $dataInicio, $dataFim),
      'membros'             => $this->Analise_model->buscarMembros(),
      'referencias1'        => $this->Analise_model->buscarReferencias1ComFiltro($idUsuario, $dataInicio, $dataFim),
      'uns_a_uns1'          => $this->Analise_model->buscarUnsAUns1ComFiltro($idUsuario, $dataInicio, $dataFim),
      'visitas1'            => $this->Analise_model->buscarVisitas1ComFiltro($idUsuario, $dataInicio, $dataFim),
      'formacoes1'          => $this->Analise_model->buscarFormacoes1ComFiltro($idUsuario, $dataInicio, $dataFim),
      'obrigado1'           => $this->Analise_model->buscarObrigados1ComFiltro($idUsuario, $dataInicio, $dataFim),
      'testemunhos1'        => $this->Analise_model->buscarTestemunhos1ComFiltro($idUsuario, $dataInicio, $dataFim),
      'faltas1'             => $this->Analise_model->buscarFaltas1ComFiltro($idUsuario, $dataInicio, $dataFim),
      'atrasos1'            => $this->Analise_model->buscarAtrasos1ComFiltro($idUsuario, $dataInicio, $dataFim),
      'error'               => '',

      'data_filtro_inicial' => $this->Analise_model->buscarDataFiltroInicial($idUsuario),
      'data_filtro_final'   => $this->Analise_model->buscarDataFiltroFinal($idUsuario),
    );
    $dados['idUsuario'] = $idUsuario;
    /*
    header("Content-Type:application/json");
    $dados['idUsuario'] = $idUsuario;
    $dados['dataInicio'] = $dataInicio; 
    $dados['dataFim'] = $dataFim;
    echo json_encode($dados);
    die();
    */
    $this->load->view('usuario/analiseperfis', $dados);
  }

}
