<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends CI_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model('Auth_model');
    $this->load->model('Auditoria_model');
  }

  public function login() {
    $cadastrar = $this->input->post('cadastro-xeque-mate');
    if (isset($cadastrar)) {
      $this->validarFormularioCadastro();
      $this->customizarMensagensValidacaoFormulario();
      if ($this->form_validation->run() == TRUE) {
        $nome       = $this->input->post('nome');
        $email      = $this->input->post('email');
        $telefone   = $this->input->post('telefone');

        $infoSistema  = $this->obterSistemaUsuario();
        $ip           = $this->obterIPUsuario();
        $os           = $infoSistema->os;
        $device       = $infoSistema->device;
        $browser      = $this->obterBrowserUsuario();

        $numeroSorteio = $this->gerarNumeroAleatorio();
        $this->db->select('numero_sorteio');
        $this->db->where('numero_sorteio', $numeroSorteio);
        $usuario = $this->db->get('usuario')->row();
        if($usuario != null){
          $numeroSorteio = $this->gerarNumeroAleatorio();
        }
        $usuario = array(
          'id'              =>null, 
          'nome'            =>$nome,
          'email'           =>$email,
          'telefone'        =>$telefone, 
          'numero_sorteio'  =>$numeroSorteio, 
          'usuario_valido'  =>false, 
          'ip_realizou_cadastro'=>$ip, 
          'cadastrado_em'       =>date('Y-m-d H:i:s'), 
          'os'                  =>$os, 
          'device'              =>$device, 
          'browser'             =>$browser,
        );
        $this->db->where('ip_realizou_cadastro', $ip);
        $this->db->where('os', $os);
        $this->db->where('device', $device);
        $confereSeUsuarioExiste = $this->db->get('usuario')->row();
        if($confereSeUsuarioExiste == null) {
          $this->db->insert('usuario', $usuario);
          $idUsuario = $this->db->insert_id();
          $this->db->where('id', $idUsuario);
          $this->db->set('usuario_valido', 1);
          $this->db->update('usuario');
          $this->session->set_flashdata('sucesso', 'Parabêns, você agora está concorrendo ao sorteio!');
        } else {
          $this->session->set_flashdata('erro', 'Ops, você já realizou um cadastro!');
        }
        redirect('auth/login', 'refresh');
      }
    }
    $this->load->view('login');
  }

  public function sorteio(){
    $usuarios = $this->db->get('usuario')->result_object();
    $data = array('usuarios'=>$usuarios, 'sorteado'=>$usuarios[array_rand($usuarios)]);
    //header("Content-Type: application/json");
    //echo json_encode($data['sorteado']->numero_sorteio, true);
    //die();
    $this->load->view('sorteio', $data);
  }

  public function sortear(){
    $usuarios = $this->db->get('usuario')->result_object();
    $data = array('usuarios'=>$usuarios, 'sorteado'=>$usuarios[array_rand($usuarios)]);
    echo json_encode($data['sorteado'], true);
  }

  public function gerarNumeroAleatorio(){
    //$letters = array("A", "B", "C", "D", "E", "F", "G");
    $numbers = array("1", "2","3","4","5","6","7","8","9");
    //$rl = array_rand($letters, 2);
    $rn = array_rand($numbers, 6);
    //$letter = $letters[$rl[0]].$letters[$rl[1]];
    $number = $numbers[$rn[0]].$numbers[$rn[1]].$numbers[$rn[2]].$numbers[$rn[3]].$numbers[$rn[4]].$numbers[$rn[5]];
    //return $letter.$number;
    return $number;
  }

  public function obterIPUsuario() {
    //OBS: Se o usuario estiver usando mais de um proxy, tunelamento esta funcao ira pegar apenas um proxy.
    $ipaddress = '';
    if (isset($_SERVER['HTTP_CLIENT_IP'])) {
      $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
      $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
      $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
      $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    } else if (isset($_SERVER['HTTP_FORWARDED'])) {
      $ipaddress = $_SERVER['HTTP_FORWARDED'];
    } else if (isset($_SERVER['REMOTE_ADDR'])) {
      $ipaddress = $_SERVER['REMOTE_ADDR'];
    } else {
      $ipaddress = 'UNKNOWN';
    }
    if ($ipaddress == '::1') {
      $ipaddress = '127.0.0.1';
    }
    return $ipaddress;
  }

  public function obterSistemaUsuario() {
    $user_agent  = $_SERVER['HTTP_USER_AGENT'];
    $os_platform = "Unknown OS Platform";
    $os_array    = array(
      '/windows phone 8/i'    => 'Windows Phone 8',
      '/windows phone os 7/i' => 'Windows Phone 7',
      '/windows nt 6.3/i'     => 'Windows 8.1',
      '/windows nt 6.2/i'     => 'Windows 8',
      '/windows nt 6.1/i'     => 'Windows 7',
      '/windows nt 6.0/i'     => 'Windows Vista',
      '/windows nt 5.2/i'     => 'Windows Server 2003/XP x64',
      '/windows nt 5.1/i'     => 'Windows XP',
      '/windows xp/i'         => 'Windows XP',
      '/windows nt 5.0/i'     => 'Windows 2000',
      '/windows me/i'         => 'Windows ME',
      '/win98/i'              => 'Windows 98',
      '/win95/i'              => 'Windows 95',
      '/win16/i'              => 'Windows 3.11',
      '/macintosh|mac os x/i' => 'Mac OS X',
      '/mac_powerpc/i'        => 'Mac OS 9',
      '/linux/i'              => 'Linux',
      '/ubuntu/i'             => 'Ubuntu',
      '/iphone/i'             => 'iPhone',
      '/ipod/i'               => 'iPod',
      '/ipad/i'               => 'iPad',
      '/android/i'            => 'Android',
      '/blackberry/i'         => 'BlackBerry',
      '/webos/i'              => 'Mobile');
    $device = '';
    foreach ($os_array as $regex => $value) {
      if (preg_match($regex, $user_agent)) {
        $os_platform = $value;
        $device      = !preg_match('/(windows|mac|linux|ubuntu)/i', $os_platform)
        ? 'MOBILE' : (preg_match('/phone/i', $os_platform) ? 'MOBILE' : 'SYSTEM');
      }
    }
    $device       = !$device ? 'SYSTEM' : $device;
    $info         = new stdClass();
    $info->os     = $os_platform;
    $info->device = $device;
    return $info;
    //return array('os' => $os_platform, 'device' => $device);
  }

  public function obterBrowserUsuario() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];

    $browser = "Unknown Browser";

    $browser_array = array(
      '/msie/i'      => 'Internet Explorer',
      '/firefox/i'   => 'Firefox',
      '/safari/i'    => 'Safari',
      '/chrome/i'    => 'Chrome',
      '/opera/i'     => 'Opera',
      '/netscape/i'  => 'Netscape',
      '/maxthon/i'   => 'Maxthon',
      '/konqueror/i' => 'Konqueror',
      '/mobile/i'    => 'Handheld Browser');

    foreach ($browser_array as $regex => $value) {
      if (preg_match($regex, $user_agent, $result)) {
        $browser = $value;
      }
    }
    return $browser;
  }

  public function configurarEmail($conteudoEmail, $emailUsuario, $assunto) {
    $this->load->library('email');

    $config["protocol"]  = "smtp";
    $config["smtp_host"] = "ssl://mail.renovarpreproducao.com.br";
    $config["smtp_user"] = "bnianalytics@renovarpreproducao.com.br";
    $config["smtp_pass"] = "bnianalytics";
    $config["charset"]   = "utf-8";
    $config["mailtype"]  = "html";
    $config["newline"]   = "\r\n";
    $config["smtp_port"] = '465';

    $this->email->initialize($config);
    $this->email->from($config["smtp_user"], $config["smtp_user"]);
    $this->email->to($emailUsuario);
    $this->email->subject($assunto);
    $this->email->message($conteudoEmail);
  }

  public function montarUrlRedefinicaoSenha($infoUsuario, $idRedefinicaoSenha) {
    $token = sha1($infoUsuario->telefone . $infoUsuario->email);
    for ($x = 0; $x <= 3; $x++) {
      $token = sha1($token);
    }
    $idUsuario = $infoUsuario->id;
    $url       = base_url('index.php/redefinirSenha/' . $token . $idUsuario . '/' . $idRedefinicaoSenha);
    return $url;
  }

  public function redefinirSenha() {
    $redefinirsenha = $this->input->post('redefinirsenha');
    if (isset($redefinirsenha)) {
      $this->validarFormularioRedefinicaoSenha();
      $this->customizarMensagensValidacaoFormulario();
      if ($this->form_validation->run() == TRUE) {
        $idUsuario          = $this->input->post('id_usuario');
        $idRedefinicaoSenha = $this->input->post('id_redefinicao_senha');
        $redefinicaoSenha   = $this->Auth_model->buscarRedefinicaoSenhaPorId($idRedefinicaoSenha);
        $infoSistema        = $this->obterSistemaUsuario();
        $redefinicaoSenha   = array(
          'id'                            => $idRedefinicaoSenha,
          'id_usuario'                    => $idUsuario,
          'requisicao_feita_em'           => $redefinicaoSenha->requisicao_feita_em,
          'email_enviado_em'              => $redefinicaoSenha->email_enviado_em,
          'url'                           => $redefinicaoSenha->url,
          'url_expirada'                  => true,
          'ip_solicitou_redefinicao'      => $redefinicaoSenha->ip_solicitou_redefinicao,
          'os_solicitou_redefinicao'      => $redefinicaoSenha->os_solicitou_redefinicao,
          'device_solicitou_redefinicao'  => $redefinicaoSenha->device_solicitou_redefinicao,
          'browser_solicitou_redefinicao' => $redefinicaoSenha->browser_solicitou_redefinicao,
          'redefinicao_realizada'         => true,
          'redefinicao_realizada_em'      => date('Y-m-d H:i:s'),
          'ip_redefiniu_senha'            => $this->obterIPUsuario(),
          'os_redefiniu_senha'            => $infoSistema->os,
          'device_redefiniu_senha'        => $infoSistema->device,
          'browser_redefiniu_senha'       => $this->obterBrowserUsuario(),
        );
        $senha = sha1($this->input->post('senha'));
        $this->Auth_model->redefinirSenha($idUsuario, $senha);
        $this->Auth_model->registrarFinalRedefinicaoSenha($idRedefinicaoSenha, $idUsuario, $redefinicaoSenha);
        $this->session->set_flashdata('sucesso', 'Sua senha foi redefinida com sucesso! Faça o login para acessar sua conta.');
        redirect('auth/login', 'refresh');
      }
    }
    $idUsuario          = substr($this->uri->segment(2), 40);
    $idRedefinicaoSenha = $this->uri->segment(3);
    $redefinicaoExpirou = $this->Auth_model->redefinicaoExpirou($idRedefinicaoSenha, $idUsuario);
    if ($redefinicaoExpirou) {
      $this->load->view('redefinicaoexpirada');
    } else {
      $this->load->view('redefinirsenha');
    }
  }

  public function customizarMensagensValidacaoFormulario() {
    $this->form_validation->set_message('required', '"%s" é obrigatório.');
    $this->form_validation->set_message('min_length', '"%s" deve conter no mínimo %d caracteres.');
    $this->form_validation->set_message('max_length', '"%s" deve conter no máximo %d caracteres.');
    $this->form_validation->set_message('matches', '"%s" não coincide com "%s".');
    $this->form_validation->set_message('trim', '"%s" não deve conter espaços.');
    $this->form_validation->set_message('numeric', '"%s" deve ser um número.');
    $this->form_validation->set_message('valid_email', '"%s" deve ser um email válido.');
  }

  public function validarFormularioCadastro() {
    $this->form_validation->set_rules('nome', 'Nome', 'trim|required|min_length[10]|max_length[100]');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[10]|max_length[100]|valid_email');
    $this->form_validation->set_rules('telefone', 'Telefone', 'trim|required|min_length[10]|max_length[100]');
  }

  public function validarFormularioEsqueceuSenha() {
    $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[5]|max_length[255]|valid_email');
  }

  public function validarFormularioRedefinicaoSenha() {
    $this->form_validation->set_rules('id_usuario', 'Id Usuario', 'trim|required|min_length[1]|numeric');
    $this->form_validation->set_rules('id_redefinicao_senha', 'Id Redefinição de Senha', 'trim|required|min_length[1]|numeric');
    $this->form_validation->set_rules('senha', 'Senha', 'trim|required|min_length[5]|max_length[40]');
    $this->form_validation->set_rules('confirmacao_senha', 'Confirmação de Senha', 'trim|required|min_length[5]|max_length[40]|matches[senha]');
  }

  public function validarFormularioRegistro() {
    $this->form_validation->set_rules('nome_usuario', 'Nome de Usuário', 'trim|required|min_length[5]|max_length[100]');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[5]|max_length[255]|valid_email');
    $this->form_validation->set_rules('senha', 'Senha', 'trim|required|min_length[5]|max_length[40]');
    $this->form_validation->set_rules('confirmacao_senha', 'Confirmação de Senha', 'trim|required|min_length[5]|max_length[40]|matches[senha]');
    $this->form_validation->set_rules('genero', 'Genero', 'trim|required|min_length[5]|max_length[50]');
    $this->form_validation->set_rules('telefone', 'Telefone', 'trim|required|min_length[5]|max_length[50]');
  }

  public function politicadeprivacidade(){
    $this->load->view('politicadeprivacidade');
  }

  public function termosdeuso(){
    $this->load->view('termosdeuso');
  }
}