<div class="content">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Vendas</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="#">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Vendas</a>
                </li>
            </ul>
            <div class="ml-md-auto py-2 py-md-0">
                <a href="<?php echo base_url('vendas/nova-venda'); ?>" class="btn btn-success btn-round"><i class="fas fa-cart-plus"></i>  Nova Venda</a>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Lançamentos</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover" >
                                <thead>
                                <tr>
                                    <th>ID</th>
                                    <th></th>
                                    <th>Produtos Vendidos</th>
                                    <th>Valor Total</th>
                                    <th>Data da Venda</th>
                                    <th>Excluir</th>
                                </tr>
                                </thead>
                                <tfoot>
                                <tr>
                                    <th>ID</th>
                                    <th></th>
                                    <th>Produtos Vendidos</th>
                                    <th>Valor Total</th>
                                    <th>Data da Venda</th>
                                    <th>Excluir</th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php foreach ($vendas as $venda) {
                                    //precisa mover isso pro controler
                                    $vendas_itens = $this->vendasmodel->listar_vendas_itens($venda->id);
                                    ?>

                                    <tr>
                                        <td><?php echo $venda->id ?></td>
                                        <td style="display:flex; align-items: center;">

                                            <?php if($venda->meio_pagamento == 'D') { ?>
                                                <i class="fas fa-money-bill-wave margin-direita"></i>
                                            <?php  } else { ?>
                                                <i class="fas fa-credit-card margin-direita"></i>
                                            <?php }  ?>


                                            <?php if($venda->observacoes == NULL) { ?>
                                                <i class="fas fa-comment-slash cor-clara"></i>
                                            <?php  } else { ?>
                                                <a href="#"><i class="fas fa-comment"></a></i>
                                            <?php }  ?>

                                        </td>
                                        <td>
                                            <?php foreach ($vendas_itens as $itens) {?>
                                                <a href="<? echo base_url('') . $itens->img; ?>"  data-lightbox="<? echo $itens->id_produto; ?>">
                                                <i class="fas fa-camera"></i>
                                                </a>
                                                <?php
                                                echo $itens->quantidade . "x <b>" . $itens->nome . "</b> - R$" . number_format($itens->valor_unitario, 2, ',', ' ') . '<br>';
                                                ?>
                                            <? } ?>

                                        </td>
                                        
                                        <td><? echo 'R$' .number_format($venda->valor_total, 2, ',', '.') ?></td>
                                        <td><? echo substr($venda->data,8,2) .'/' .substr($venda->data,5,2) .'/' .substr($venda->data,0,4); ?></td>
                                        
                                        <td><a href="<?php echo base_url('vendas/excluir/'.$venda->id) ?>" class="btn btn-danger btn-sm"><i class="far fa-trash-alt"></i></a></td>
                                    </tr>

                                <? } ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>