<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title><?php echo $titulo?></title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="<?php echo base_url(''); ?>assets/img/icon.ico" type="image/x-icon"/>

    <!-- Fonts and icons -->
    <script src="<?php echo base_url(''); ?>assets/js/plugin/webfont/webfont.min.js"></script>
    <script>
        WebFont.load({
            google: {"families":["Lato:300,400,700,900"]},
            custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands", "simple-line-icons"], urls: ['<?php echo base_url(''); ?>assets/css/fonts.min.css']},
            active: function() {
                sessionStorage.fonts = true;
            }
        });
    </script>

    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo base_url(''); ?>assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo base_url(''); ?>assets/css/atlantis.min.css">
    
    <link rel="stylesheet" href="<?php echo base_url(''); ?>assets/css/login.css">
</head>
<body>
<section class="h-100">
<div class="container h-100">
    <div class="d-flex align-items-center justify-content-center h-100">
        <div class="col-sm-9 col-md-7 col-lg-5 mx-auto">
            <div class="text-center"><a href="<?php echo base_url(''); ?>"><img src="<?php echo base_url(''); ?>assets/img/logo.svg" alt="Olympia" class="logo"></a></div>

            <div class="card card-signin">
                <div class="card-body">
                    <h5 class="card-title text-center"><b>Painel Administrativo</b></h5>
                    <?php
                        echo validation_errors('<div class"alert alert-danger">','</div>');
                        echo form_open('adminacesso/login','class="form-signin"');
                    ?>
                        <div class="form-label-group">
                            <input type="text" id="inputEmail" name="txt-user" class="form-control" placeholder="Seu email..." required autofocus>
                            <label for="inputEmail">Usuário</label>
                        </div>

                        <div class="form-label-group">
                            <input type="password" id="inputPassword" name="txt-senha" class="form-control" placeholder="Sua senha..." required>
                            <label for="inputPassword">Senha</label>
                        </div>

                        <button class="btn btn-lg btn-danger btn-block text-uppercase" type="submit">Entrar</button>
                    <?php
                        echo form_close();
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
</section>
<!--   Core JS Files   -->
<script src="<?php echo base_url(''); ?>assets/js/core/jquery.3.2.1.min.js"></script>
<script src="<?php echo base_url(''); ?>assets/js/core/popper.min.js"></script>
<script src="<?php echo base_url(''); ?>assets/js/core/bootstrap.min.js"></script>

<!-- jQuery UI -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js"></script>
<script src="<?php echo base_url(''); ?>assets/js/plugin/jquery-ui-touch-punch/jquery.ui.touch-punch.min.js"></script>

<!-- jQuery Scrollbar -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js"></script>


<!-- Chart JS -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/chart.js/chart.min.js"></script>

<!-- jQuery Sparkline -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/jquery.sparkline/jquery.sparkline.min.js"></script>

<!-- Chart Circle -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/chart-circle/circles.min.js"></script>

<!-- Datatables -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/datatables/datatables.min.js"></script>

<!-- Bootstrap Notify -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/bootstrap-notify/bootstrap-notify.min.js"></script>

<!-- jQuery Vector Maps -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/jqvmap/jquery.vmap.min.js"></script>
<script src="<?php echo base_url(''); ?>assets/js/plugin/jqvmap/maps/jquery.vmap.world.js"></script>

<!-- Sweet Alert -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/sweetalert/sweetalert.min.js"></script>

</body>
</html>