<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Vendas_model extends CI_Model
{

    public $id_usuario;
    public $id_produtos;
    public $nome;
    public $valor;
    public $img;
    public $id;
    public $quantidade_atual;
    public $quantidade_contratada;
    public $ultima_atualizacao;


    public function __construct()
    {
        parent::__construct();
    }


    //Lista as vendas a partir do id do usuário
    public function listar_vendas($id)
    {
        $this->db->select('
            vendas.id_usuario,
            vendas.id,
            vendas.data,
            vendas.valor_total, 
            vendas.meio_pagamento,
            vendas.observacoes  
        ');
        $this->db->from('vendas');
        $this->db->order_by('vendas.id', 'DESC');
        $this->db->where('id_usuario =' . $id);
        $this->db->where('cancelado','N');
        return $this->db->get('')->result();
    }

    //lista vendas da home do admin (exibe 4 itens)
    public function listar_vendas_home_admin()
    {
        $this->db->select('
            vendas.id_usuario,
            vendas.id,
            vendas.data,
            vendas.valor_total,
            usuarios.nome   
        ');
        $this->db->from('vendas');
        $this->db->join('usuarios', 'usuarios.id = vendas.id_usuario');
        $this->db->order_by('vendas.id', 'DESC');
        $this->db->where('cancelado','N');
        $this->db->limit(4);
        return $this->db->get('')->result();
    }

    //Listar Vendas Admin
    public function listar_vendas_admin()
    {
        $this->db->select('
            vendas.id_usuario,
            vendas.id,
            vendas.data,
            vendas.valor_total,
            vendas.cancelado,
            usuarios.nome   
        ');
        $this->db->from('vendas');
        $this->db->join('usuarios', 'usuarios.id = vendas.id_usuario');
        $this->db->order_by('vendas.id', 'DESC');
        return $this->db->get('')->result();
    }



    //Lista os itens da venda dentro da venda
    public function listar_vendas_itens($id)
    {
        $this->db->select('
            venda_filho.id_produto,
            venda_filho.quantidade,
            venda_filho.valor_unitario,
            venda_filho.valor_total,
            produtos.nome,
            produtos.img
        ');
        $this->db->from('venda_filho');
        $this->db->join('produtos', 'produtos.id = venda_filho.id_produto');
        $this->db->where('id_venda =' . $id);
        return $this->db->get('')->result();
    }


    //pega ultima venda pra lançar nova venda
    public function pegaid()
    {
        $this->db->select('
            vendas.id,
        ');
        $this->db->from('vendas');
        $this->db->limit(1);
        $this->db->order_by('vendas.id', 'DESC');
        return $this->db->get('')->result();
    }


    //Lista produtos usado no formulário para adicionar nova venda
    public function listar_produtos($id){
        $this->db->select('
            produtos.id as idprodutos,
            produtos.nome,
            produtos.valor,
            produtos.img,
            estoques.id_usuario,
            estoques.id,
            estoques.id_produto,
            estoques.quantidade_atual,
            ');
        $this->db->from('estoques');
        $this->db->join('produtos','produtos.id = estoques.id_produto');
        $this->db->order_by('produtos.nome','ASC');
        $this->db->where('id_usuario ='.$id);
        return $this->db->get('')->result();
    }

    //Lista preços usado no formulário para adicionar nova venda
    public function pegaprecoproduto($id){
        $this->db->select('
            produtos.id,
            produtos.valor
            ');
        $this->db->from('produtos');
        $this->db->where('produtos.id ='.$id);
        return $this->db->get('')->result();
    }



    //Adiciona no Banco uma nova venda
    public function adicionar($id_produto, $quantidade, $valor_unitario, $valor_total, $id_usuario, $data, $id_venda)
    {

        $armazena_vendas['id_usuario'] = $id_usuario;
        $armazena_vendas['data'] = $data;
        $armazena_vendas['valor_total'] = $valor_total;
        $this->db->insert('vendas', $armazena_vendas);

        $armazena_vendas_filho['id_venda'] = $id_venda;
        $armazena_vendas_filho['id_produto'] = $id_produto;
        $armazena_vendas_filho['quantidade'] = $quantidade;
        $armazena_vendas_filho['valor_unitario'] = $valor_unitario;
        $armazena_vendas_filho['valor_total'] = $valor_total;
        $this->db->insert('venda_filho', $armazena_vendas_filho);

        $sqlBaixa = "update estoques set quantidade_atual = (quantidade_atual - " .$quantidade .") where id_usuario = " .$id_usuario ." and id_produto= " .$id_produto;
        $this->db->query($sqlBaixa);

        return TRUE;
    }
    


    public function excluir ($id) {
       //$this->db->where('md5(id)',$id);
        //return $this->db->delete('vendas');


        $sqlUpdate = "update vendas set cancelado = 'S' where id = " .$id;
        $this->db->query($sqlUpdate);

        return TRUE;
    }

    public function buscaproduto ($id) {
        //$this->db->where('md5(id)',$id);
         //return $this->db->delete('vendas');
 
        $this->db->select('
            *
        ');
        $this->db->from('produtos');
        $this->db->limit(1);
        $this->db->where('id ='.$id);
        return $this->db->get('')->result();
         
     }

    public function gravaitemtemporario($id_produto, $usuario, $quantidade, $valor_unitario) {
        $valor_total = $quantidade * $valor_unitario;
        $sqlBaixa = "insert into venda_filho_temp (id, id_usuario, id_produto, quantidade, valor_unitario, valor_total) values (null, $usuario, $id_produto, $quantidade, '$valor_unitario','$valor_total')";
        $this->db->query($sqlBaixa);

        return TRUE;
    }


    public function zeraitemtemporario($usuario) {
        $sqlBaixa = "delete from venda_filho_temp where id_usuario = $usuario";
        $this->db->query($sqlBaixa);

        return TRUE;
    }


    
    public function busca_item_temporario($usuario) {
        //$this->db->where('md5(id)',$id);
         //return $this->db->delete('vendas');
 
        $this->db->select('
            produtos.nome,
            produtos.img,
            produtos.descricao,
            venda_filho_temp.*
            
        ');
        $this->db->from('venda_filho_temp');
        $this->db->join('produtos','produtos.id = venda_filho_temp.id_produto');
        $this->db->where('id_usuario ='.$usuario);
        return $this->db->get('')->result();
         
     }






}