<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Vendas extends CI_Controller {

    public function __construct(){
        parent::__construct();

        //Aqui eu valido se o usário está logado,
        // se nao estiver, redireciona pro login
        if(!$this->session->userdata('logado')){
            redirect(base_url(''));
        }
        //pego o id do usuário logado
        $id_usuario = $this->session->userdata('userlogado')->id;
        //incializo o model
        $this->load->model('vendas_model','vendasmodel');
        //executo
        $this->vendas = $this->vendasmodel->listar_vendas($id_usuario);

  
        
    }





	public function index()
	{
		$dados['titulo'] = 'Vendas';
        $dados['vendas'] = $this->vendas;

		$this->load->view('template/html-header',$dados);
		$this->load->view('template/header');
		$this->load->view('template/aside');
		$this->load->view('conteudo/vendas');
		$this->load->view('template/footer');
        $this->load->view('conteudo/vendas-extra');
		$this->load->view('template/html-footer');
	}





    public function nova()
    {
        $dados['titulo'] = 'Nova Venda';
        

        $id_usuario = $this->session->userdata('userlogado')->id;

        $this->vendasmodel->zeraitemtemporario($id_usuario);
        $this->produtos = $this->vendasmodel->listar_produtos($id_usuario);
        $dados['produtos'] = $this->produtos;
        $dados['id_usuario'] = $id_usuario;

    



        $this->load->view('template/html-header',$dados);
        $this->load->view('template/header');
        $this->load->view('template/aside');
        $this->load->view('conteudo/vendanova');
        $this->load->view('template/footer');
        $this->load->view('conteudo/vendanova-extra');
        $this->load->view('template/html-footer');
    }

    public function excluir ($id) {
        if ($this->vendasmodel->excluir($id)) {
            redirect(base_url('vendas'));
        }else{
            echo "Houve um erro";
            //redirect(base_url('vendas'));
        }
    }





    public function adiciona_venda(){
        $id_produto = $this->input->post('id_produto');
        $quantidade = $this->input->post('quantidade');

        $pegapreco = $this->vendasmodel->pegaprecoproduto($id_produto);
        foreach ($pegapreco as $valor) {
            $valor_unitario = $valor->valor;
        } 
        //$valor_unitario = str_replace('$valor_unitario')
        $valor_total = $quantidade * $valor_unitario;
        $data = Date("Y-m-d H:i:s");
        $id_usuario = $this->session->userdata('userlogado')->id;
        $id_venda = $this->input->post('ultimo-pedido');
        $id_pronto = $id_venda + 1;

        if ($this->vendasmodel->adicionar($id_produto, $quantidade, $valor_unitario, $valor_total, $id_usuario, $data, $id_pronto)) {
            redirect(base_url('vendas'));
        }else{
            echo "Houve um erro";
            //redirect(base_url('vendas'));
        }
    }


    public function adiciona_temporario(){
        $acao = $this->input->post('acao');
        $quantidade_produtos = $this->input->post('quantidade_produtos');
        $usuario = $this->input->post('usuario');
        $id_produto = $this->input->post('id_produto');
        $tipo = $this->input->post('tipo');
        $quantidade = $this->input->post('quantidade');

        if ($tipo == 'add') {
            //arrumar isso depois
            
            $linhasprodutos = $this->vendasmodel->buscaproduto($id_produto);
            foreach ($linhasprodutos as $linhaproduto) {
                $valor_unitario = $linhaproduto->valor;
            } 
            $this->vendasmodel->gravaitemtemporario($id_produto, $usuario, $quantidade, $valor_unitario);
            $dados['itenstemporarios'] = $this->vendasmodel->busca_item_temporario($usuario);
            $this->load->view('conteudo/tabela-temporaria',$dados);
        }
    }

    public function exclui_temporario ($id) {
        if ($this->vendasmodel->exclui_temporario($id)) {
            redirect(base_url('vendas'));
        }else{
            echo "Houve um erro";
            //redirect(base_url('vendas'));
        }
    }


}
