<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inicio extends CI_Controller {


    public function __construct(){
        parent::__construct();

        //Aqui eu valido se o usário está logado,
        // se nao estiver, redireciona pro login
        if(!$this->session->userdata('logado')){
            redirect(base_url(''));
        }
    }

	public function index()
	{
		$dados['titulo'] = 'Início';
		$dados['nomeacademia'] = 'Prolife Gym';

        //pego o id do usuário logado, incializo o model, executo
        $id_usuario = $this->session->userdata('userlogado')->id;
        $this->load->model('vendas_model','vendasmodel');
        $this->vendas = $this->vendasmodel->listar_vendas($id_usuario);

        $dados['vendas'] = $this->vendas;


		$this->load->view('template/html-header',$dados);
		$this->load->view('template/header');
		$this->load->view('template/aside');
		$this->load->view('conteudo/dashboard');
		$this->load->view('template/footer');
        $this->load->view('conteudo/dashboard-extra');
		$this->load->view('template/html-footer');
	}
}
