<?php
    $vendedor = $this->input->get('vendedor');
    $periodo = $this->input->get('periodo');
    $status = $this->input->get('status');

    $somatotal = $this->vendasmodel->soma_total_vendas($id_usuario, $vendedor, $periodo, $status);
    $numerototal = $this->vendasmodel->numero_total_vendas($id_usuario, $vendedor, $periodo, $status);
    
?>

<div class="content">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Vendas</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="#">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Vendas</a>
                </li>
            </ul>
            <div class="ml-md-auto py-2 py-md-0">
                <a href="<?php echo base_url('vendas/nova-venda'); ?>" class="btn btn-success btn-round"><i class="fas fa-cart-plus"></i>  Nova Venda</a>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex flex-row justify-content-between align-items-center">
                        <h4 class="card-title">Registros de Vendas</h4>
                        <div class="">
                            <div class="">
                                <button class="btn btn-danger btn-sm btn-round" type="button" data-toggle="collapse" data-target="#collapseExample1" aria-expanded="false" aria-controls="collapseExample1">
                                <i class="fas fa-filter"></i> Filtros
                                </button>


                            </div>
                        </div>
                    </div>
                    <div class="collapse" id="collapseExample1" >
                        <div class="card-body">
                            <form class="px-2 py-0">
                                <div class="row align-items-center">
                                    <div class="col-sm-3">
                                        <div class="form-group px-0">
                                            <label for="exampleDropdownFormEmail1"><i class="fas fa-dumbbell"></i> Vendedor</label>
                                            <input type="text" class="form-control" id="vendedor" name="vendedor" placeholder="Exibir Todos" <?php if(!$vendedor == null) { echo "value='$vendedor'"; } ?>>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group px-0">
                                            <label for="exampleDropdownFormEmail1"><i class="far fa-calendar-alt"></i> Período</label>
                                            <input type="text" class="form-control" id="periodo" name="periodo" placeholder="Exibir Todos" <?php if(!$periodo == null) { echo "value='$periodo'"; } ?>>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group px-0">
                                            <label class="form-label d-block"><i class="fas fa-eye"></i> Status</label>
                                            <div class="selectgroup selectgroup-danger selectgroup-pills">
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="status" value="pago" class="selectgroup-input" <?php if($status == 'pago') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon"><i class="fas fa-check-circle"></i></span>
                                                </label>
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="status" value="acertado" class="selectgroup-input" <?php if($status == 'acertado') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon"><i class="fas fa-circle"></i></span>
                                                </label>
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="status" value="nao_acertado" class="selectgroup-input" <?php if($status == 'nao_acertado') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon"><i class="fas fa-times-circle"></i></span>
                                                </label>
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="status" value="todos" class="selectgroup-input" <?php if($status == 'todos') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon">Todos</span>
                                                </label>
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                    <button type="submit" class="btn btn-success btn-round largura-total">Filtrar</button>
                                    </div>
                                
                                </div>
                            </form>
                        </div>
                    </div>
                    <?
                        //Aqui eu vejo na sessão de foi enviada a mensagem de erro junto do redirecionamento
                        $in = $this->session->flashdata('mensagem');
                        if($in==1)
                        {
                            echo "<div class='card-header alerta-vermelho'><i class='fas fa-exclamation-triangle'></i> Venda excluída com sucesso!</div>";
                        }
                    ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-6">
								<div class="card card-stats card-round">
									<div class="card-body bg-primary-gradient">
										<div class="row">
                                            <div class="col-2">
												<div class="icon-big text-center">
													<i class="flaticon-chart-pie text-white"></i>
												</div>
											</div>
											<div class="col-10 col-stats">
												<div class="numbers">
													<p class="card-category text-white">Número Total de Vendas</p>
													<h4 class="card-title text-white"><? if ($numerototal[0]->quantidade == null) { echo '0';} else { echo $numerototal[0]->quantidade;} ?></h4>
												</div>
											</div>
										</div>
									</div>
								</div>
                            </div>
                            <div class="col-sm-6">
								<div class="card card-stats card-round">
									<div class="card-body bg-primary-gradient text-white">
										<div class="row">
											<div class="col-2">
												<div class="icon-big text-center">
													<i class="fas fa-dollar-sign text-white"></i>
												</div>
											</div>
											<div class="col-10 col-stats">
												<div class="numbers">
													<p class="card-category text-white">Valor Total de Vendas</p>
													<h4 class="card-title text-white"><? if ($somatotal[0]->valor_total_somado == null) { echo 'R$0,00';} else { echo 'R$' .number_format($somatotal[0]->valor_total_somado, 2, ',', '.');} ?></h4>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
                    
                        </div>
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover" >
                                <thead>
                                <tr>
                                    <th>ID</th>
                                    <th></th>
                                    <th>Produtos Vendidos</th>
                                    <th>Valor Total</th>
                                    <th>Data da Venda</th>
                                    <th>Vendedor</th>
                                    <th>Status</th>
                                    <th>Excluir</th>
                                </tr>
                                </thead>
                                <tfoot>
                                <tr>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th><? if ($somatotal[0]->valor_total_somado == null) { echo 'R$0,00';} else { echo 'R$' .number_format($somatotal[0]->valor_total_somado, 2, ',', '.');} ?></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php foreach ($vendas as $venda) {
                                    //precisa mover isso pro controler
                                    $vendas_itens = $this->vendasmodel->listar_vendas_itens($venda->id);
                                    ?>

                                    <tr>
                                        <td><?php echo $venda->id ?></td>
                                        <td style="display:flex; align-items: center;">

                                            <?php if($venda->meio_pagamento == 'D') { ?>
                                                <i class="fas fa-money-bill-wave margin-direita"></i>
                                            <?php  } else { ?>
                                                <i class="fas fa-credit-card margin-direita"></i>
                                            <?php }  ?>


                                            <?php if($venda->observacoes == NULL) { ?>
                                                <i class="fas fa-comment-slash cor-clara"></i>
                                            <?php  } else { ?>
                                                <a href="#" data-toggle="modal" data-target="#exampleModalCenter-<?php echo $venda->id ?>"><i class="fas fa-comment"></i></a>   
                                                

                                                <!-- Modal -->
                                                <div class="modal fade" id="exampleModalCenter-<?php echo $venda->id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLongTitle">Comentário do Pedido</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                    <?php echo $venda->observacoes; ?>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                                                    </div>
                                                    </div>
                                                </div>
                                                </div>
                                            <?php }  ?>

                                        </td>
                                        <td>
                                            <?php foreach ($vendas_itens as $itens) {?>
                                                <? if (!$itens->img) { ?>
                                                    <i class="fas fa-camera" style="color: #e4e4e4;"></i>
                                                <? } else { ?>
                                                    <a href="<? echo base_url('') . $itens->img; ?>"  data-lightbox="<? echo $itens->id_produto; ?>">
                                                        <i class="fas fa-camera"></i>
                                                    </a>
                                                <? } ?>

                                                
                                                <?php
                                                echo $itens->quantidade . "x <b>" . $itens->nome . "</b> - R$" . number_format($itens->valor_unitario, 2, ',', ' ') . '<br>';
                                                ?>
                                            <? } ?>

                                        </td>
                                        
                                        <td><? echo 'R$' .number_format($venda->valor_total, 2, ',', '.') ?></td>
                                        <td><? echo substr($venda->data,8,2) .'/' .substr($venda->data,5,2) .'/' .substr($venda->data,0,4); ?></td>

                                        <td>
                                            <?php if(!$venda->vendedor) { ?>
                                                
                                            <?php  } else { ?>
                                                <?php echo $venda->vendedor ?>
                                            <?php }  ?>
                                        </td>

                                        <td style="text-align: center; font-size: 17px">
                                            <?php if($venda->acertado == 'P') { ?>
                                                <i style="color: green" class="fas fa-check-circle" data-toggle="tooltip" data-placement="top" title="Pago"></i>
                                            <?php  } elseif($venda->acertado == 'S') { ?>
                                                <i style="color: #dccd06" class="fas fa-circle" data-toggle="tooltip" data-placement="top" title="Faturado, aguardando pagamento"></i>
                                            <?php  } else { ?>
                                                <i style="color: red" class="fas fa-times-circle" data-toggle="tooltip" data-placement="top" title="Ainda não faturado"></i>
                                            <?php }  ?>

                                        </td>
                                        
                                        
                                        <td>
                                            <?php if($venda->acertado == 'N') { ?>
                                                <a href="<?php echo base_url('vendas/excluir/'.$venda->id) ?>" class="btn btn-danger btn-sm btn-round"><i class="far fa-trash-alt"></i></a> 
                                            <?php  } else { ?>
                                                <a href="#" class="btn btn-outline-dark btn-sm btn-round disabled" disabled><i class="far fa-trash-alt"></i></a>
                                            <?php }  ?>
                                        </td>
                                    </tr>

                                <? } ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>