<?php
$id_usuario = $this->session->userdata('userlogado')->id;
$produto = $this->input->get('produto');
$periodo = $this->input->get('periodo');
$somatotal = $this->modelestoque->listar_soma_vendas_produto($id_usuario, $produto , $periodo);
$somatotalestoques = $this->modelestoque->listar_soma_estoques_produto($id_usuario, $produto);
?>
<div class="content">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Estoque</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="#">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Estoque</a>
                </li>
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header  d-flex flex-row">
                        <h4 class="card-title">Produtos</h4>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a class="btn btn-danger btn-sm btn-round" href="<?php echo base_url('estoque/imprimir'); ?>" target="_blank">
                            <i class="fas fa-print"></i> Imprimir
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover" >
                                <thead>
                                <tr>
                                    <th></th>
                                    <th data-toggle="tooltip" data-placement="bottom" title="Nome do Produto">Nome do Produto</th>
                                    <th data-toggle="tooltip" data-placement="bottom" title="Preço de Venda">Preço de Venda</th>
                                    <th data-toggle="tooltip" data-placement="bottom" title="Número de produtos disponíveis no estoque">Estoque Atual</th>
                                    <th data-toggle="tooltip" data-placement="bottom" title="Valor total dos produtos em estoque">Total em Estoque</th>
                                    <th data-toggle="tooltip" data-placement="bottom" title="Número de produtos vendidos em aberto e aguardando criação do Acerto">Quant. em Aberto</th>
                                    <th data-toggle="tooltip" data-placement="bottom" title="Valor total dos produtos vendidos em aberto e aguardando criação do Acerto">Vendas em Aberto</th>
                                    <th data-toggle="tooltip" data-placement="bottom" title="Data que foi feita a última reposição de estoque">Última Reposição</th>
                                    
                                </tr>
                                </thead>
                                <tfoot>
                                <tr>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th><? if ($somatotalestoques[0]->quantidade == null) { echo '0';} else { echo $somatotalestoques[0]->quantidade;} ?></th>
                                    <th><? if ($somatotalestoques[0]->valor_total_somado == null) { echo 'R$0,00';} else { echo 'R$' .number_format($somatotalestoques[0]->valor_total_somado, 2, ',', '.');} ?></th>
                                    <th><? if ($somatotal[0]->quantidade == null) { echo '0';} else { echo $somatotal[0]->quantidade;} ?></th>
                                    <th><? if ($somatotal[0]->valor_total_somado == null) { echo 'R$0,00';} else { echo 'R$' .number_format($somatotal[0]->valor_total_somado, 2, ',', '.');} ?></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php foreach ($estoques as $estoque) { ?>

                                    <tr>
                                    
                                        <td>
                                            <? if (!$estoque->img) {?>
                                                <a href="<? echo base_url('assets/img/sem-imagem.jpg') ?>"  data-lightbox="<? echo $estoque->id_produto; ?>">
                                                    <img src="<? echo base_url('assets/img/sem-imagem.jpg') . $estoque->img; ?>" alt="<? echo $estoque->nome; ?>" class="imagem-produto-reduzida">
                                                </a>
                                            <? } else { ?>
                                                <a href="<? echo base_url('') . $estoque->img; ?>"  data-lightbox="<? echo $estoque->id_produto; ?>">
                                                    <img src="<? echo base_url('') . $estoque->img; ?>" alt="<? echo $estoque->nome; ?>" class="imagem-produto-reduzida">
                                                </a>
                                            <? } ?>
                                        </td>
                                        <td class="paragrafo-magin-zero">
                                        <?php if($estoque->descricao == NULL) { ?>
                                            
                                            <?php  } else { ?>
                                                <a href="#" data-toggle="modal" data-target="#exampleModalCenter-<?php echo $estoque->id_produto ?>"><i class="fas fa-plus-circle"></i></a>   
                                                <!-- Modal -->
                                                <div class="modal fade" id="exampleModalCenter-<?php echo $estoque->id_produto ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                                        <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Descrição do Produto</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                        <?php echo $estoque->descricao ?>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                                                        </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php }  ?>

                                            <b><? echo $estoque->nome; ?></b>
                                        </td>
                                        <td><? echo 'R$' .number_format($estoque->valor, 2, ',', '.'); ?></td>
                                        <td><? echo $estoque->quantidade_atual; ?></td>
                                        <td><? echo 'R$' .number_format($estoque->valor_atual, 2, ',', '.'); ?></td>
                                        <td><? echo $estoque->quantidade_acerto; ?></td>
                                        <td><? echo 'R$' .number_format($estoque->valor_acerto, 2, ',', '.'); ?></td>
                                        <td><? echo substr($estoque->ultima_atualizacao,8,2) .'/' .substr($estoque->ultima_atualizacao,5,2) .'/' .substr($estoque->ultima_atualizacao,0,4); ?></td>
                                        
                                    </tr>

                                <? } ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>