<?php
if(!$estoques) {
    $id_usuario = 0;
} else {
    $id_usuario = $estoques[0]->id_usuario;
}

$produto = $this->input->get('produto');
$periodo = $this->input->get('periodo');
$somatotal = $this->modelestoque->listar_soma_vendas_produto($id_usuario, $produto , $periodo);
$somatotalestoques = $this->modelestoque->listar_soma_estoques_produto($id_usuario, $produto);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title><?php echo $titulo?></title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="<?php echo base_url(''); ?>assets/img/icon.ico" type="image/x-icon"/>

    <!-- Fonts and icons -->
    <script src="<?php echo base_url(''); ?>assets/js/plugin/webfont/webfont.min.js"></script>
    <script>
        WebFont.load({
            google: {"families":["Lato:300,400,700,900"]},
            custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands", "simple-line-icons"], urls: ['<?php echo base_url(''); ?>assets/css/fonts.min.css']},
            active: function() {
                sessionStorage.fonts = true;
            }
        });
    </script>

    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo base_url(''); ?>assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo base_url(''); ?>assets/css/atlantis.css">
    <link rel="stylesheet" href="<?php echo base_url(''); ?>assets/css/lightbox.min.css">

    <!-- CSS Just for demo purpose, don't include it in your project -->
    <link rel="stylesheet" href="<?php echo base_url(''); ?>assets/css/demo.css">
    <style>
    tr {
        border-bottom: 1px solid #ccc;
    }
    tr:last-child {
        border-bottom: none;
    }
    </style>
</head>
<body>
<div class="container">
    <div class="page-inner">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex flex-row" style="justify-content: space-between;align-items: center;">
                        <h4 class="card-title"><img src="<?php echo base_url(''); ?>assets/img/logo-imprecao.jpg" alt=""></h4>
                        <h4>Relatório de Estoque de <?php echo $this->session->userdata('userlogado')->nome; ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover" >
                                <thead>
                                <tr>
                                    <th></th>
                                    <th>Nome do Produto</th>
                                    <th>Estoque Atual</th>
                                    <th>Quantidade em Aberto</th>
                                    <th>Última Reposição</th>
                                    <th>Valor</th>
                                </tr>
                                </thead>
                                <tfoot>
                                <tr>
                                    <th></th>
                                    <th></th>
                                    <th><? if ($somatotalestoques[0]->quantidade == null) { echo '0';} else { echo $somatotalestoques[0]->quantidade;} ?></th>
                                    <th><? if ($somatotal[0]->quantidade == null) { echo '0';} else { echo $somatotal[0]->quantidade;} ?></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php foreach ($estoques as $estoque) { ?>

                                    <tr>
                                    
                                        <td>
                                            <? if (!$estoque->img) {?>
                                                <a href="<? echo base_url('assets/img/sem-imagem.jpg') ?>"  data-lightbox="<? echo $estoque->id_produto; ?>">
                                                    <img src="<? echo base_url('assets/img/sem-imagem.jpg') . $estoque->img; ?>" alt="<? echo $estoque->nome; ?>" class="imagem-produto-reduzida">
                                                </a>
                                            <? } else { ?>
                                                <a href="<? echo base_url('') . $estoque->img; ?>"  data-lightbox="<? echo $estoque->id_produto; ?>">
                                                    <img src="<? echo base_url('') . $estoque->img; ?>" alt="<? echo $estoque->nome; ?>" class="imagem-produto-reduzida">
                                                </a>
                                            <? } ?>
                                        </td>
                                        <td class="paragrafo-magin-zero">
                                            <p><b><? echo $estoque->nome; ?></b></p>
                                            <p><? echo $estoque->descricao; ?></p>
                                        </td>
                                        <td><? echo $estoque->quantidade_atual; ?></td>
                                        <td><? echo $estoque->quantidade_acerto; ?></td>
                                        <td><? echo substr($estoque->ultima_atualizacao,8,2) .'/' .substr($estoque->ultima_atualizacao,5,2) .'/' .substr($estoque->ultima_atualizacao,0,4); ?></td>
                                        <th>R$<? echo $estoque->valor; ?></th>
                                    </tr>

                                <? } ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
function myFunction() {
  window.print();
}
myFunction();
</script>
    <!--   Core JS Files   -->
<script src="<?php echo base_url(''); ?>assets/js/core/jquery.3.2.1.min.js"></script>
<script src="<?php echo base_url(''); ?>assets/js/core/popper.min.js"></script>
<script src="<?php echo base_url(''); ?>assets/js/core/bootstrap.min.js"></script>

<!-- jQuery UI -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js"></script>
<script src="<?php echo base_url(''); ?>assets/js/plugin/jquery-ui-touch-punch/jquery.ui.touch-punch.min.js"></script>

<!-- jQuery Scrollbar -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js"></script>


<!-- Chart JS -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/chart.js/chart.min.js"></script>

<!-- jQuery Sparkline -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/jquery.sparkline/jquery.sparkline.min.js"></script>

<!-- Chart Circle -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/chart-circle/circles.min.js"></script>

<!-- Datatables -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/datatables/datatables.min.js"></script>

<!-- Bootstrap Notify -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/bootstrap-notify/bootstrap-notify.min.js"></script>

<!-- jQuery Vector Maps -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/jqvmap/jquery.vmap.min.js"></script>
<script src="<?php echo base_url(''); ?>assets/js/plugin/jqvmap/maps/jquery.vmap.world.js"></script>

<!-- Sweet Alert -->
<script src="<?php echo base_url(''); ?>assets/js/plugin/sweetalert/sweetalert.min.js"></script>

<script src="<?php echo base_url(''); ?>assets/js/lightbox.min.js"></script>

<!-- Atlantis JS -->
<script src="<?php echo base_url(''); ?>assets/js/atlantis.min.js"></script>

</body>
</html>