<?php

$produto = $this->input->get('produto');
$periodo = $this->input->get('periodo');
$numero_total = $this->estatisticasmodel->dashboard_academia_numero_total_venda($periodo, $id_usuario);
$faturamento = $this->estatisticasmodel->dashboard_academia_faturamento($periodo, $id_usuario);
$total_acerto = $this->estatisticasmodel->dashboard_total_acerto_aberto($id_usuario);
//$mais_vendidos = $this->estatisticasmodel->pag_estatistica_mais_vendidos();
?>
<div class="content">
                <div class="panel-header bg-danger-gradient">
                    <div class="page-inner py-5">
                        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                            <div>
                                <h2 class="text-white pb-2 fw-bold"><?php echo $titulo?></h2>
                                <h5 class="text-white op-7 mb-2">Seja Bem Vindo(a) <?php echo $this->session->userdata('userlogado')->nome; ?></h5>
                            </div>
                            <div class="ml-md-auto py-2 py-md-0">
                                <a href="<?php echo base_url('vendas/nova-venda'); ?>" class="btn btn-light btn-round"><i class="fas fa-cart-plus"></i>  Nova Venda</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="page-inner mt--5">
                    <div class="row row-card-no-pd">
                        <div class="col-md-12">
                            <div class="row align-items-center" style="margin: 0 0 30px; background: #f0f0f0; border-radius: 10px">
                                <div class="col-md-8"><i class="far fa-calendar-alt"></i> Filtrar por Período</div>
                                <div class="col-md-4">
                                    <form class="px-2 py-0">
                                        <div class="row align-items-center">
                                            <div class="col-sm-8">
                                                <div class="form-group px-0">
                                                    <input type="text" class="form-control" id="periodo" name="periodo" placeholder="Exibir Todos" <?php if(!$periodo == null) { echo "value='$periodo'"; } ?>>
                                                </div>
                                            </div>
                                        
                                            <div class="col-sm-4">
                                            <button type="submit" class="btn btn-success btn-round largura-total">Filtrar</button>
                                            </div>
                                        
                                        </div>
                                    </form>
                                
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="card card-stats card-round card-primary bg-danger-gradient">
                                <div class="card-body ">
                                    <div class="row">
                                        <div class="col-2">
                                            <div class="icon-big text-center">
                                                <i class="flaticon-chart-pie text-warning"></i>
                                            </div>
                                        </div>
                                        <div class="col-8 col-stats">
                                            <div class="numbers" id="resultado_numero_total">
                                                <p class="card-category">Número de Vendas</p>
                                                <h4 class="card-title"><b><?echo $numero_total[0]->numero_total_vendas;?></b> Vendas Realizadas</h4>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-4">
                            <div class="card card-stats card-round card-primary bg-danger-gradient">
                                <div class="card-body ">
                                    <div class="row">
                                        <div class="col-2">
                                            <div class="icon-big text-center">
                                                <i class="flaticon-coins text-success"></i>
                                            </div>
                                        </div>
                                        <div class="col-8 col-stats">
                                            <div class="numbers" id="resultado_faturamento_total">
                                                <p class="card-category">Faturamento Bruto</p>
                                                <h4 class="card-title"><?echo 'R$<b>' .number_format($faturamento[0]->valor_total_somado, 2, ',', '.') ?></b></h4>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-4">
                            <div class="card card-stats card-round card-primary bg-danger-gradient">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-2">
                                            <div class="icon-big text-center">
                                                <i class="fas fa-receipt text-danger"></i>  
                                            </div>
                                        </div>
                                        <div class="col-10 col-stats">
                                            <div class="numbers">
                                                <p class="card-category">Valor de Acertos em Aberto</p>
                                                <h4 class="card-title"><? echo 'R$<b>' .number_format($total_acerto[0]->valor_total_somado, 2, ',', '.') ?></b></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt--2">
                        <div class="col-md-12">
                            <div class="card full-height">
                                <div class="card-body">
                                    <div class="card-title">Últimas Vendas Realizadas</div>
                                    <div class="row py-3">
                                        <div class="col-md-12">
                                            <div class="table-responsive">
                                                <table id="basic-datatables" class="display table table-striped table-hover" >
                                                    <thead>
                                                    <tr>
                                                        <th>Produtos</th>
                                                        <th>Valor Total</th>
                                                        <th>Data da Venda</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach ($vendas as $venda) {
                                                        //precisa mover isso pro controler
                                                        $vendas_itens = $this->vendasmodel->listar_vendas_itens($venda->id);
                                                        ?>

                                                        <tr>
                                                            <td>
                                                                <?php foreach ($vendas_itens as $itens) {?>
                                                                    <?php
                                                                    echo $itens->quantidade . "x <b>" . $itens->nome . "</b> - R$" . $itens->valor_unitario . '<br>';
                                                                    ?>
                                                                <? } ?>

                                                            </td>
                                                            <td>R$<? echo $venda->valor_total; ?></td>
                                                            <td><? echo substr($venda->data,8,2) .'/' .substr($venda->data,5,2) .'/' .substr($venda->data,0,4); ?></td>

                                                        </tr>

                                                    <? } ?>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>