<?php
    $academia = $this->input->get('academia');
    $periodo = $this->input->get('periodo');
    $cancelado = $this->input->get('cancelado');
    

?>

<div class="content">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Vendas</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="#">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Vendas</a>
                </li>
            </ul>
        
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                <div class="card-header d-flex flex-row justify-content-between align-items-center">
                        <h4 class="card-title">Registro de Vendas</h4>
                        <div class="">
                            <div class="">
                                <button class="btn btn-danger btn-sm btn-round" type="button" data-toggle="collapse" data-target="#collapseExample1" aria-expanded="false" aria-controls="collapseExample1">
                                <i class="fas fa-filter"></i> Filtros
                                </button>


                            </div>
                        </div>
                    </div>


                    <div class="collapse" id="collapseExample1" >
                        <div class="card-body">
                            <form class="px-2 py-0">
                                <div class="row align-items-center">
                                    <div class="col-sm-3">
                                        <div class="form-group px-0">
                                            <label for="exampleDropdownFormEmail1"><i class="fas fa-dumbbell"></i> Academia</label>
                                            <input type="text" class="form-control" id="academia" name="academia" placeholder="Exibir Todas" <?php if(!$academia == null) { echo "value='$academia'"; } ?>>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group px-0">
                                            <label for="exampleDropdownFormEmail1"><i class="far fa-calendar-alt"></i> Período</label>
                                            <input type="text" class="form-control" id="periodo" name="periodo" placeholder="Exibir Todos" <?php if(!$periodo == null) { echo "value='$periodo'"; } ?>>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group px-0">
                                            <label class="form-label d-block"><i class="fas fa-eye"></i> Ocultar Cancelados?</label>
                                            <div class="selectgroup selectgroup-danger selectgroup-pills">
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="cancelado" value="exibe" class="selectgroup-input" <?php if($cancelado == 'exibe') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon"><i class="fas fa-eye"></i></span>
                                                </label>
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="cancelado" value="oculta" class="selectgroup-input" <?php if($cancelado == 'oculta') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon"><i class="fas fa-eye-slash"></i></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                    <button type="submit" class="btn btn-success btn-round largura-total">Filtrar</button>
                                    </div>
                                
                                </div>
                            </form>
                        </div>
                    </div>
                    <?
                        //Aqui eu vejo na sessão de foi enviada a mensagem de erro junto do redirecionamento
                        $in = $this->session->flashdata('mensagem');
                        if($in==1)
                        {
                            echo "<div class='card-header alerta-vermelho'><i class='fas fa-exclamation-triangle'></i> Venda excluída com sucesso!</div>";
                        }
                    ?>


                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover" >
                                <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Usuário</th>
                                    <th>Produtos Vendidos</th>
                                    <th>Valor Total</th>
                                    <th>Acertado</th>
                                    <th>Data da Venda</th>
                                </tr>
                                </thead>
                                <tfoot>
                                <tr>
                                    <th>ID</th>
                                    <th>Usuário</th>
                                    <th>Produtos Vendidos</th>
                                    <th>Valor Total</th>
                                    <th>Acertado</th>
                                    <th>Data da Venda</th>
                                    
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php foreach ($vendas as $venda) {
                                    //precisa mover isso pro controler
                                    $vendas_itens = $this->vendasmodel->listar_vendas_itens($venda->id);
                                    ?>
                                    <? if ($venda->cancelado == 'S') { ?>
                                        <tr style="opacity: 0.3" class="venda-cancelada">
                                            <td><? echo $venda->id; ?></td>
                                            <td><a href="<? echo base_url('admin/vendas/academia/') . $venda->id_usuario; ?>"><? echo $venda->nome ?></a></td>
                                            <td>
                                                <?php foreach ($vendas_itens as $itens) {?>
                                                    <?php if(!$itens->img) {?>
                                                        <i style="color: #ccc" class="fas fa-camera"></i>
                                                    <?php } else { ?>
                                                        <a href="<? echo base_url('') . $itens->img; ?>"  data-lightbox="<? echo $itens->id_produto; ?>">
                                                            <i class="fas fa-camera"></i>
                                                        </a>
                                                    <?php } ?>
                                                    <?php
                                                    echo $itens->quantidade . "x <b>" . $itens->nome . "</b> - R$" . number_format($itens->valor_unitario, 2, ',', ' ') . '<br>';
                                                    ?>
                                                <? } ?>

                                            </td>
                                            <td class="preco-antes"><? echo $venda->valor_total; ?></td>
                                            <td style="text-align: center; font-size: 17px">
                                                <i style="color: rgb(197, 197, 197)" class="fas fa-ban" data-toggle="tooltip" data-placement="top" title="Venda excluída">
                                            </td>
                                            <td><? echo substr($venda->data,8,2) .'/' .substr($venda->data,5,2) .'/' .substr($venda->data,0,4); ?></td>
                                            
                                        </tr>
                                    <? }else{ ?>
                                        <tr>
                                        <td><? echo $venda->id; ?></td>
                                        <td><a href="<? echo base_url('admin/vendas/academia/') . $venda->id_usuario; ?>"><? echo $venda->nome ?></a></td>
                                        <td>
                                            <?php foreach ($vendas_itens as $itens) {?>
                                                <?php if(!$itens->img) {?>
                                                    <i style="color: #ccc" class="fas fa-camera"></i>
                                                <?php } else { ?>
                                                    <a href="<? echo base_url('') . $itens->img; ?>"  data-lightbox="<? echo $itens->id_produto; ?>">
                                                        <i class="fas fa-camera"></i>
                                                    </a>
                                                <?php } ?>
                                                <?php
                                                echo $itens->quantidade . "x <b>" . $itens->nome . "</b> - R$" . number_format($itens->valor_unitario, 2, ',', ' ') . '<br>';
                                                ?>
                                            <? } ?>

                                        </td>
                                        <td class="preco-antes"><? echo $venda->valor_total?></td>
                                        <td style="text-align: center; font-size: 17px">
                                            <?php if($venda->acertado == 'P') { ?>
                                                <i style="color: green" class="fas fa-check-circle" data-toggle="tooltip" data-placement="top" title="Pago"></i>
                                            <?php  } elseif($venda->acertado == 'S') { ?>
                                                <i style="color: #dccd06" class="fas fa-circle" data-toggle="tooltip" data-placement="top" title="Faturado, aguardando pagamento"></i>
                                            <?php  } else { ?>
                                                <i style="color: red" class="fas fa-times-circle" data-toggle="tooltip" data-placement="top" title="Ainda não faturado"></i>
                                            <?php }  ?>
                                        </td>
                                        <td><? echo substr($venda->data,8,2) .'/' .substr($venda->data,5,2) .'/' .substr($venda->data,0,4); ?></td>
                                        
                                    </tr>
                                    <? } ?>

                                    

                                <? } ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script>
    function exibeeoculta() {
        //$('.venda-cancelada').toggle("slide", { direction: "right" }, 1000);
        $(".venda-cancelada").toggle();
    }
    </script>