<?php

$periodo = $this->input->get('periodo');
$total_receber = $this->estatisticasmodel->pag_estatistica_total_receber($periodo);
$total_acerto = $this->estatisticasmodel->pag_estatistica_total_acerto($periodo);
$numero_total = $this->estatisticasmodel->pag_estatistica_numero_total_venda($periodo);
$faturamento = $this->estatisticasmodel->pag_estatistica_faturamento($periodo);
$mais_vendidos = $this->estatisticasmodel->pag_estatistica_mais_vendidos($periodo);
$melhores_vendedores = $this->estatisticasmodel->pag_estatistica_melhores_vendedores($periodo);
?>

<div class="content">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Dashboard</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="#">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Dashboard</a>
                </li>
            </ul>
        
        </div>

        <div class="row row-card-no-pd">
            <div class="col-md-12">
                <div class="row align-items-center" style="margin: 0 0 30px; background: #f0f0f0; border-radius: 10px">
                    <div class="col-md-8"><i class="far fa-calendar-alt"></i> Filtrar por Período</div>
                    <div class="col-md-4">
                        <form class="px-2 py-0">
                            <div class="row align-items-center">
                                <div class="col-sm-8">
                                    <div class="form-group px-0">
                                        <input type="text" class="form-control" id="periodo" name="periodo" placeholder="Exibir Todos" <?php if(!$periodo == null) { echo "value='$periodo'"; } ?>>
                                    </div>
                                </div>
                            
                                <div class="col-sm-4">
                                <button type="submit" class="btn btn-success btn-round largura-total">Filtrar</button>
                                </div>
                            
                            </div>
                        </form>
                    
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-md-6 mb-2">
                <div class="card card-stats card-round card-primary bg-danger-gradient">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-2">
                                <div class="icon-big text-center">
                                    <i class="flaticon-chart-pie text-warning"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers" id="resultado_numero_total">
                                    <p class="card-category">Número Total de Vendas</p>
                                    <h4 class="card-title"><b><?= $numero_total[0]->numero_total_vendas;?></b> Vendas Realizadas</h4>
                                </div>
                                <div id="processando_numero_total" style="display:none;">
                                    <i class="icon-refresh"></i> Processando...  
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 mb-2">
                <div class="card card-stats card-round card-primary bg-danger-gradient">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-2">
                                <div class="icon-big text-center">
                                    <i class="flaticon-coins text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers" id="resultado_faturamento_total">
                                    <p class="card-category">Faturamento Total</p>
                                    <h4 class="card-title"><? echo 'R$<b>' .number_format($faturamento[0]->valor_total_somado, 2, ',', '.') ?></b></h4>
                                </div>
                                <div id="processando_faturamento_total" style="display:none;">
                                    <i class="icon-refresh"></i> Processando...  
                                </div>
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 mb-2">
                <div class="card card-stats card-round card-primary bg-danger-gradient">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-2">
                                <div class="icon-big text-center">
                                    <i class="flaticon-cart-1 text-danger"></i>
                                </div>
                            </div>
                            <div class="col-10 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Vendas em Aberto</p>
                                    <h4 class="card-title"><? echo 'R$<b>' .number_format($total_receber[0]->valor_total_somado, 2, ',', '.') ?></b></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 mb-2">
                <div class="card card-stats card-round card-primary bg-danger-gradient">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-2">
                                <div class="icon-big text-center">
                                <i class="flaticon-file"></i>
                                </div>
                            </div>
                            <div class="col-10 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Valor Acertos</p>
                                    <h4 class="card-title"><? echo 'R$<b>' .number_format($total_acerto[0]->valor_total_somado, 2, ',', '.') ?></b></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12" style="margin-top: 40px;">
            <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">Produtos Mais Vendidos</div>
                    </div>
                    <div class="card-body">
                        <table class="table table-head-bg-success">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Produto</th>
                                    <th scope="col">Qtd</th>
                                    <th scope="col">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                            <? 
                                    $posicao = 1;
                                    foreach($mais_vendidos as $item): 
                                ?>
                                    <tr>
                                        <td><?= $posicao?></td>
                                        <td><?= $item->nome;?></td>
                                        <td><?= $item->quantidade_somada;?></td>
                                        <td><? echo 'R$<b>' .number_format($item->valor_total_somado, 2, ',', '.') ?></td>
                                    </tr>
                                <? 
                                $posicao = $posicao+1;
                                endforeach ?>
                            </tbody>
                        </table>
                        
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">Melhores Vendedores</div>
                    </div>
                    <div class="card-body">
                        <table class="table table-head-bg-success">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Academia</th>
                                    <th scope="col">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <? 
                                    $posicao = 1;
                                    foreach($melhores_vendedores as $item): 
                                ?>
                                    <tr>
                                        <td><?= $posicao?></td>
                                        <td><?= $item->nome;?></td>
                                        <td><? echo 'R$<b>' .number_format($item->valor_total_somado, 2, ',', '.') ?></td>
                                    </tr>
                                <? 
                                $posicao = $posicao+1;
                                endforeach ?>
                            </tbody>
                        </table>
                        
                    </div>
                </div>
            </div>
        </div>
            </div>
        </div>
        
    </div>
