<?php
$produto = $this->input->get('produto');
$periodo = $this->input->get('periodo');
$somatotal = $this->estatisticasmodel->listar_soma_vendas_produto($produto , $periodo);
$somatotalestoques = $this->estatisticasmodel->listar_soma_estoques_produto($produto);

?>

<div class="content">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Produtos</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="#">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Produtos</a>
                </li>
            </ul>
        
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">



                    <div class="card-header d-flex flex-row justify-content-between align-items-center">
                        <h4 class="card-title">Produtos</h4>
                        <div class="">
                            <div class="">
                                <button class="btn btn-danger btn-sm btn-round" type="button" data-toggle="collapse" data-target="#collapseExample1" aria-expanded="false" aria-controls="collapseExample1">
                                <i class="fas fa-filter"></i> Filtros
                                </button>


                            </div>
                        </div>
                    </div>
                    <div class="collapse" id="collapseExample1" >
                        <div class="card-body">
                            <form class="px-2 py-0">
                                <div class="row align-items-center">
                                    <div class="col-sm-3">
                                        <div class="form-group px-0">
                                            <label for="exampleDropdownFormEmail1"><i class="fas fa-dumbbell"></i> Produto</label>
                                            <input type="text" class="form-control" id="produto" name="produto" placeholder="Exibir Todos"<?php if(!$produto == null) { echo "value='$produto'"; } ?>>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group px-0">
                                            <label for="exampleDropdownFormEmail1"><i class="far fa-calendar-alt"></i> Período</label>
                                            <input type="text" class="form-control" id="periodo" name="periodo" placeholder="Exibir Todos" <?php if(!$periodo == null) { echo "value='$periodo'"; } ?>>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <b>Atenção:</b> a busca por <b>Período</b> influenciará apenas nas colunas <b>Quantidade em Aberto</b> e <b>Vendas em Aberto</b>
                                    </div>
                                    <div class="col-sm-3">
                                    <button type="submit" class="btn btn-success btn-round largura-total">Filtrar</button>
                                    </div>
                                
                                </div>
                            </form>
                        </div>
                    </div>
                    <?
                        //Aqui eu vejo na sessão de foi enviada a mensagem de erro junto do redirecionamento
                        $in = $this->session->flashdata('mensagem');
                        if($in==1)
                        {
                            echo "<div class='card-header alerta-vermelho'><i class='fas fa-exclamation-triangle'></i> Venda excluída com sucesso!</div>";
                        }
                    ?>     




                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover" >
                            
                                <thead>
                                <tr>
                                    <th data-toggle="tooltip" data-placement="top" title="Nome do Produto">Produto</th>
                                    
                                    <th data-toggle="tooltip" data-placement="top" title="Preço do Produto">Preço</th>
                                    <th data-toggle="tooltip" data-placement="top" title="Quantidade total do produto disponível nos estoques das academias">Em Estoque</th>
                                    <th data-toggle="tooltip" data-placement="top" title="Valor total de mercadoria disponível nos estoques das academias">Total Estoque</th>
                                    <th data-toggle="tooltip" data-placement="top" title="Número de vendas recentes que ainda não foram gerados os acertos">Quant. em Aberto</th>
                                    <th data-toggle="tooltip" data-placement="top" title="Valores das vendas recentes que ainda não foram gerados os acertos">Vendas em Aberto</th>
                                    <th>Ação</th>
                                </tr>
                                </thead>
                                <tfoot>
                                <tr>

                                    <th></th>
                                    <th></th>
                                    <th><? if ($somatotalestoques[0]->quantidade == null) { echo '0';} else { echo $somatotalestoques[0]->quantidade;} ?></th>
                                    <th><? if ($somatotalestoques[0]->valor_total_somado == null) { echo 'R$0,00';} else { echo 'R$' .number_format($somatotalestoques[0]->valor_total_somado, 2, ',', '.');} ?></th>
                                    <th><? if ($somatotal[0]->quantidade == null) { echo '0';} else { echo $somatotal[0]->quantidade;} ?></th>
                                    <th><? if ($somatotal[0]->valor_total_somado == null) { echo 'R$0,00';} else { echo 'R$' .number_format($somatotal[0]->valor_total_somado, 2, ',', '.');} ?></th>
                                    <th></th>
                                    
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php foreach ($produtos as $item) { ?>
                                    <? $vendas_produto = $this->estatisticasmodel->listar_vendas_produto($item->id, $periodo); ?>
                                    <? $estoques_produto = $this->estatisticasmodel->listar_estoques_produto($item->id);?>
                                    <tr>
                                        <td>
                                            <a href="<?= base_url('') . $item->img; ?>"  data-lightbox="<? echo $item->id; ?>">
                                                <i class="fas fa-camera"></i>
                                            </a> 
                                            <?= $item->nome; ?></td>
                                            
                                        <td>
                                            R$<?= number_format($item->valor, 2, ',', '.'); ?>
                                        </td>
                                        <td><? if ($estoques_produto[0]->quantidade == null) { echo '0';} else { echo $estoques_produto[0]->quantidade;} ?></td>
                                        <td><? if ($estoques_produto[0]->valor_total_somado == null) { echo 'R$ 0,00';} else { echo "R$ ".number_format($estoques_produto[0]->valor_total_somado, 2, ',', '.');} ?></td>
                                        <td><? if ($vendas_produto[0]->quantidade == null) { echo '0';} else { echo $vendas_produto[0]->quantidade;} ?></td>
                                        <td><? if ($vendas_produto[0]->valor_total_somado == null) { echo 'R$ 0,00';} else { echo "R$ ".number_format($vendas_produto[0]->valor_total_somado, 2, ',', '.');} ?></td>
                                        <td><a href="<? echo base_url('admin/estatisticas/produtos/detalhe/'.$item->id) ?>" class="btn btn-danger btn-round btn-sm" ><i class="fas fa-plus"></i> Detalhes</a></td>
                                        
                                    </tr>
                          

                                <? } ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
