<?php
if($acertos == null) {
    redirect(base_url('admin/academias'));
}
$numdoc = $this->input->get('numdoc');
   $emissao = $this->input->get('emissao');
   $vencimento = $this->input->get('vencimento');
   $status = $this->input->get('status');
?>
<div class="content">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Acertos</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="#">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?php echo base_url('admin/acertos'); ?>">Acertos</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?php echo base_url('admin/acertos'); ?>">Acertos de <?= $acertos[0]->nome; ?></a>
                </li>
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                <div class="card-header d-flex flex-row justify-content-between align-items-center">
                        <h4 class="card-title">Acertos</h4>
                        <div class="">
                            <div class="">
                                <button class="btn btn-danger btn-sm btn-round" type="button" data-toggle="collapse" data-target="#collapseExample1" aria-expanded="false" aria-controls="collapseExample1">
                                <i class="fas fa-filter"></i> Filtros
                                </button>


                            </div>
                        </div>
                    </div>
                    
                    <div class="collapse" id="collapseExample1" >
                        <div class="card-body">
                            <form class="px-2 py-0">
                                <div class="row align-items-center">
                                    <div class="col-sm-2">
                                        <div class="form-group px-0">
                                            <label for="exampleDropdownFormEmail1"><i class="fas fa-file-invoice-dollar"></i> Númro do Documento</label>
                                            <input type="text" class="form-control" id="numdoc" name="numdoc" placeholder="Exibir Todos" <?php if(!$numdoc == null) { echo "value='$numdoc'"; } ?>>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group px-0">
                                            <label for="exampleDropdownFormEmail1"><i class="far fa-calendar-alt"></i> Data de Emissão</label>
                                            <input type="text" class="form-control" id="emissao" name="emissao" placeholder="Exibir Todos" <?php if(!$emissao == null) { echo "value='$emissao'"; } ?>>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group px-0">
                                            <label for="exampleDropdownFormEmail1"><i class="far fa-calendar-alt"></i> Data de Vencimento</label>
                                            <input type="text" class="form-control" id="vencimento" name="vencimento" placeholder="Exibir Todos" <?php if(!$vencimento == null) { echo "value='$vencimento'"; } ?>>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group px-0">
                                            <label class="form-label d-block"><i class="fas fa-eye"></i> Status</label>
                                            <div class="selectgroup selectgroup-danger selectgroup-pills">
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="status" value="quitado" class="selectgroup-input" <?php if($status == 'quitado') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon">Quitado</span>
                                                </label>
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="status" value="transito" class="selectgroup-input" <?php if($status == 'transito') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon">Em Trânsito</span>
                                                </label>
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="status" value="aberto" class="selectgroup-input" <?php if($status == 'aberto') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon">Aberto</span>
                                                </label>
                                                <label class="selectgroup-item">
                                                    <input type="radio" name="status" value="todos" class="selectgroup-input" <?php if($status == 'todos') { echo "checked=''"; } ?>>
                                                    <span class="selectgroup-button selectgroup-button-icon">Todos</span>
                                                </label>
                                                
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                    <button type="submit" class="btn btn-success btn-round largura-total">Filtrar</button>
                                    </div>
                                
                                </div>
                            </form>
                        </div>
                    </div>
                    <?
                        //Aqui eu vejo na sessão de foi enviada a mensagem de erro junto do redirecionamento
                        $in = $this->session->flashdata('mensagem');
                        if($in==1)
                        {
                            echo "<div class='card-header alerta-vermelho'><i class='fas fa-exclamation-triangle'></i> Venda excluída com sucesso!</div>";
                        }
                    ?>
                        
                    <div class="card-body">
                        <?php //var_dump($acertos);?>
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover" >
                                <thead>
                                <tr>
                                    <th>Cód. Doc.</th>
                                    <th>Número do Documento</th>
                                    <th>Data de Emissão</th>                                   
                                    <th>Valor Doc.</th>
                                    <th>Situação</th>
                                    <th>Mais Detalhes</th>
                                </tr>
                                </thead>
                                <tfoot>
                                <tr>
                                    <th></th>
                                    <th></th>
                                    <th></th>                                   
                                    <th>R$<?= number_format($somatotal[0]->vrdoc, 2, ',', '.')?></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <? foreach ($acertos as $acerto) { ?> 
                                    <tr>
                                        <td><?= $acerto->coddoc?></td>
                                        <td><?= $acerto->numdoc?></td>
                                        <td><?= date("d/m/Y", strtotime($acerto->dataemis));?></td>                                   
                                        <td><b class="text-success">R$ <?= number_format($acerto->vrdoc, 2, ',', ' ')?></b></td>
                                        <td><? if($acerto->situacao == 'A') {
                                            echo 'Aberto';
                                        } elseif ($acerto->situacao == 'T') {
                                            echo 'Em Trânsito';
                                        } elseif ($acerto->situacao == 'Q') {
                                            echo 'Quitado';
                                        } else {
                                            echo 'Situação não cadastrada';
                                        }
                                        ?></td>
                                        <td>
                                            <a href="#" data-toggle="modal" data-target="#exampleModalCenter-<?php echo $acerto->coddoc ?>" class="btn btn-danger btn-sm btn-round"><i class="fas fa-search-plus"></i> Ver Mais</a> 

                                                

                                                <!-- Modal -->
                                                <div class="modal fade" id="exampleModalCenter-<?php echo $acerto->coddoc ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                    <div class="modal-header">
                                                        <div class="modal-title" id="exampleModalLongTitle"><h2><?= $acerto->numdoc?></h2>
                                                        <small><?= $acerto->nome?></small>
                                                    </div>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body detalhes-acerto">
                                                     <div class="row">
                                                         <div class="col-md-6">
                                                            <div class="conteudo-detalhes-acerto">
                                                                <b>Data de Emissão</b>
                                                                <?= date("d/m/Y", strtotime($acerto->dataemis));?>
                                                            </div>
                                                             
                                                         </div>
                                                         <div class="col-md-6">
                                                            <div class="conteudo-detalhes-acerto">
                                                                <b>Data de Vencimento</b>
                                                                <b class="text-danger"><?= date("d/m/Y", strtotime($acerto->datavenc));?></b>
                                                            </div>  
                                                         </div>
                                                     </div>
                                                     <div class="row">
                                                         <div class="col-md-3">
                                                            <div class="conteudo-detalhes-acerto">
                                                                <b>Desconto</b>
                                                                R$ <?= number_format($acerto->vrdesc, 2, ',', ' ')?>
                                                            </div>
                                                             
                                                         </div>
                                                         <div class="col-md-3">
                                                            <div class="conteudo-detalhes-acerto">
                                                                <b>Acréscimo</b>
                                                                R$ <?= number_format($acerto->vracresc, 2, ',', ' ')?>
                                                            </div>  
                                                         </div>
                                                         <div class="col-md-3">
                                                            <div class="conteudo-detalhes-acerto">
                                                                <b>Juros</b>
                                                                R$ <?= number_format($acerto->vrjuros, 2, ',', ' ')?>
                                                            </div>
                                                             
                                                         </div>
                                                         <div class="col-md-3">
                                                            <div class="conteudo-detalhes-acerto ">
                                                                <b>Total</b>
                                                                <b class="text-success">R$ <?= number_format($acerto->vrdoc, 2, ',', ' ')?></b>
                                                            </div>  
                                                         </div>
                                                     </div>
                                                     <div class="row">
                                                         <div class="col-md-4">
                                                            <div class="conteudo-detalhes-acerto">
                                                                <b>Status</b>
                                                                <? if($acerto->situacao == 'A') {
                                                                    echo 'Aberto';
                                                                } elseif ($acerto->situacao == 'T') {
                                                                    echo 'Em Trânsito';
                                                                } elseif ($acerto->situacao == 'Q') {
                                                                    echo 'Quitado';
                                                                } else {
                                                                    echo 'Situação não cadastrada';
                                                                }?>
                                                            </div>
                                                             
                                                         </div>
                                                         <div class="col-md-4">
                                                            <div class="conteudo-detalhes-acerto">
                                                                <b>Data do Pagamento</b>
                                                                <?if($acerto->datapago < $acerto->datavenc) {
                                                                    echo "-";
                                                                } else {
                                                                    echo date("d/m/Y", strtotime($acerto->datapago));
                                                                } ?>
                                                            </div>  
                                                         </div>
                                                         <div class="col-md-4">
                                                            <div class="conteudo-detalhes-acerto">
                                                                <b>Valor Pago</b>
                                                                <?if($acerto->vrpago =='0.00') {
                                                                    echo "-";
                                                                } else {
                                                                    echo "R$".number_format($acerto->vrpago, 2, ',', ' ');
                                                                } ?>
                                                            </div>
                                                             
                                                         </div>
                                                     </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Fechar</button>
                                                    </div>
                                                    </div>
                                                </div>
                                                </div>
                                        
                                        </td>
                                    </tr>    
                                <? } ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>