<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Vendas_model extends CI_Model
{

    public $id_usuario;
    public $id_produtos;
    public $nome;
    public $valor;
    public $img;
    public $id;
    public $quantidade_atual;
    public $quantidade_contratada;
    public $ultima_atualizacao;


    public function __construct()
    {
        parent::__construct();
    }


    //Lista as vendas a partir do id do usuário
    public function listar_vendas($id, $vendedor, $periodo, $status)
    {
        $this->db->select('
            vendas.id_usuario,
            vendas.id,
            vendas.data,
            vendas.valor_total, 
            vendas.meio_pagamento,
            vendas.acertado,
            vendas.observacoes,
            vendas.vendedor 
        ');
        $this->db->from('vendas');
        $this->db->order_by('vendas.id', 'DESC');
        $this->db->where('id_usuario =' . $id);
        $this->db->where('cancelado','N');

        if (!$vendedor == NULL) {
            $where = "vendedor LIKE '%".$vendedor."%'";
            $this->db->where($where);
        }
        //Verifico o periodo
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        if (!$status == NULL) {
            if($status == 'pago') {
                $this->db->where('acertado','P');
            }elseif ($status == 'acertado') {
                $this->db->where('acertado','S');
            }elseif ($status == 'nao_acertado') {
                $this->db->where('acertado','N');
            }else {

            }
        }

        return $this->db->get('')->result();
    }


    //soma o valot total das vendas a partir do id do usuário
    public function soma_total_vendas($id, $vendedor, $periodo, $status)
    {
        $this->db->select('
            sum(valor_total) as valor_total_somado
        ');
        $this->db->from('vendas');
        $this->db->where('id_usuario =' . $id);
        $this->db->where('cancelado','N');

        if (!$vendedor == NULL) {
            $where = "vendedor LIKE '%".$vendedor."%'";
            $this->db->where($where);
        }
        //Verifico o periodo
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        if (!$status == NULL) {
            if($status == 'pago') {
                $this->db->where('acertado','P');
            }elseif ($status == 'acertado') {
                $this->db->where('acertado','S');
            }elseif ($status == 'nao_acertado') {
                $this->db->where('acertado','N');
            }else {

            }
        }

        return $this->db->get('')->result();
    }

    //soma o numero total das vendas a partir do id do usuário
    public function numero_total_vendas($id, $vendedor, $periodo, $status)
    {
        $this->db->select('
            count(id) as quantidade
        ');
        $this->db->from('vendas');
        $this->db->where('id_usuario =' . $id);
        $this->db->where('cancelado','N');

        if (!$vendedor == NULL) {
            $where = "vendedor LIKE '%".$vendedor."%'";
            $this->db->where($where);
        }
        //Verifico o periodo
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        if (!$status == NULL) {
            if($status == 'pago') {
                $this->db->where('acertado','P');
            }elseif ($status == 'acertado') {
                $this->db->where('acertado','S');
            }elseif ($status == 'nao_acertado') {
                $this->db->where('acertado','N');
            }else {

            }
        }

        return $this->db->get('')->result();
    }


    //Lista as vendas a partir do id do usuário
    public function listar_vendas_home_usuario($id)
    {
        $this->db->select('
            vendas.id_usuario,
            vendas.id,
            vendas.data,
            vendas.valor_total, 
            vendas.meio_pagamento,
            vendas.acertado,
            vendas.observacoes,
            vendas.vendedor 
        ');
        $this->db->from('vendas');
        $this->db->order_by('vendas.id', 'DESC');
        $this->db->where('id_usuario =' . $id);
        $this->db->where('cancelado','N');
        $this->db->limit(4);

        return $this->db->get('')->result();
    }

    //lista vendas da home do admin (exibe 4 itens)
    public function listar_vendas_home_admin()
    {
        $this->db->select('
            vendas.id_usuario,
            vendas.id,
            vendas.data,
            vendas.valor_total,
            usuarios.nome   
        ');
        $this->db->from('vendas');
        $this->db->join('usuarios', 'usuarios.id = vendas.id_usuario');
        $this->db->order_by('vendas.id', 'DESC');
        $this->db->where('cancelado','N');
        $this->db->limit(4);
        return $this->db->get('')->result();
    }

    //Listar Vendas Admin
    public function listar_vendas_admin($academia, $periodo, $cancelado)
    {
        $this->db->select('
            vendas.id_usuario,
            vendas.id,
            vendas.data,
            vendas.valor_total,
            vendas.meio_pagamento,
            vendas.acertado,
            vendas.observacoes,  
            vendas.cancelado,
            usuarios.nome   
        ');
        $this->db->from('vendas');
        $this->db->join('usuarios', 'usuarios.id = vendas.id_usuario');
        if (!$academia == NULL) {
            $where = "nome LIKE '%".$academia."%'";
            $this->db->where($where);
            //$this->db->where('nome', $academia);
        }
        //Verifico o periodo
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        if (!$cancelado == NULL) {
            if($cancelado == 'oculta') {
                $this->db->where('cancelado','N');
            }
        }
        $this->db->order_by('vendas.id', 'DESC');
        return $this->db->get('')->result();
    }


    //Listar Vendas Por Academia no admin
    public function listar_vendas_academia_admin($id, $periodo, $cancelado)
    {
        $this->db->select('
            vendas.id_usuario,
            vendas.id,
            vendas.data,
            vendas.valor_total,
            vendas.meio_pagamento,
            vendas.acertado,
            vendas.observacoes,  
            vendas.cancelado,
            usuarios.nome   
        ');
        $this->db->from('vendas');
        $this->db->join('usuarios', 'usuarios.id = vendas.id_usuario');
        $this->db->where('id_usuario =' . $id);
        //Verifico o periodo
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        if (!$cancelado == NULL) {
            if($cancelado == 'oculta') {
                $this->db->where('cancelado','N');
            }
        }
        $this->db->order_by('vendas.id', 'DESC');
        return $this->db->get('')->result();
    }



    //Listar Vendas por Academia no admin com coluna ACERTADO = S 
    public function listar_vendas_acertar_academia_admin($id)
    {
        $this->db->select('
            vendas.id_usuario,
            vendas.id,
            vendas.data,
            vendas.valor_total,
            vendas.meio_pagamento,
            vendas.acertado,
            vendas.observacoes,  
            vendas.cancelado,
            usuarios.nome   
        ');
        $this->db->from('vendas');
        $this->db->join('usuarios', 'usuarios.id = vendas.id_usuario');
        $this->db->where('id_usuario =' . $id);
        $this->db->where('acertado', 's');
        $this->db->order_by('vendas.id', 'DESC');
        return $this->db->get('')->result();
    }



    //Lista os itens da venda dentro da venda
    public function listar_vendas_itens($id)
    {
        $this->db->select('
            venda_filho.id_produto,
            venda_filho.quantidade,
            venda_filho.valor_unitario,
            venda_filho.valor_total,
            produtos.nome,
            produtos.img
        ');
        $this->db->from('venda_filho');
        $this->db->join('produtos', 'produtos.id = venda_filho.id_produto');
        $this->db->where('id_venda =' . $id);
        return $this->db->get('')->result();
    }
    


    //pega ultima venda pra lançar nova venda
    public function pegaid()
    {
        $this->db->select('
            vendas.id,
        ');
        $this->db->from('vendas');
        $this->db->limit(1);
        $this->db->order_by('vendas.id', 'DESC');
        return $this->db->get('')->result();
    }


    //Lista produtos usado no formulário para adicionar nova venda
    public function listar_produtos($id){
        $this->db->select('
            produtos.id as idprodutos,
            produtos.nome,
            produtos.valor,
            produtos.img,
            estoques.id_usuario,
            estoques.id,
            estoques.id_produto,
            estoques.quantidade_atual,
            ');
        $this->db->from('estoques');
        $this->db->join('produtos','produtos.id = estoques.id_produto');
        $this->db->order_by('produtos.nome','ASC');
        $this->db->where('id_usuario ='.$id);
        return $this->db->get('')->result();
    }

    //Lista preços usado no formulário para adicionar nova venda
    public function pegaprecoproduto($id){
        $this->db->select('
            produtos.id,
            produtos.valor
            ');
        $this->db->from('produtos');
        $this->db->where('produtos.id ='.$id);
        return $this->db->get('')->result();
    }



    //Adiciona no Banco uma nova venda
    public function adicionar($id_produto, $quantidade, $valor_unitario, $valor_total, $id_usuario, $data, $id_venda)
    {

        $armazena_vendas['id_usuario'] = $id_usuario;
        $armazena_vendas['data'] = $data;
        $armazena_vendas['valor_total'] = $valor_total;
        $this->db->insert('vendas', $armazena_vendas);

        $armazena_vendas_filho['id_venda'] = $id_venda;
        $armazena_vendas_filho['id_produto'] = $id_produto;
        $armazena_vendas_filho['quantidade'] = $quantidade;
        $armazena_vendas_filho['valor_unitario'] = $valor_unitario;
        $armazena_vendas_filho['valor_total'] = $valor_total;
        $this->db->insert('venda_filho', $armazena_vendas_filho);

        //$sqlBaixa = "update estoques set quantidade_atual = (quantidade_atual - " .$quantidade .") where id_usuario = " .$id_usuario ." and id_produto= " .$id_produto;
        //  $this->db->query($sqlBaixa);

        return TRUE;
    }


    public function busca_vendas_filho ($id) {
        //$this->db->where('md5(id)',$id);
         //return $this->db->delete('vendas');
 
        $this->db->select('
            *
        ');
        $this->db->from('venda_filho');
        $this->db->where('id_venda ='.$id);
        return $this->db->get('')->result();
     }
    


    public function excluir ($id, $usuario) {
        
        //desativo o produto na venda do cliente
        $sqlUpdate = "update vendas set cancelado = 'S' where id = " .$id;
        $this->db->query($sqlUpdate);


        //Aqui eu reponho o produto em estoque
        $linhas_vendas = $this->vendasmodel->busca_vendas_filho($id);

        foreach ($linhas_vendas as $linha_venda)  {
            $id_produto = $linha_venda->id_produto;
            $quantidade = $linha_venda->quantidade;
            $sqlRepoemEstoque = "update estoques set quantidade_atual = (quantidade_atual + " .$quantidade .") where id_usuario = " .$usuario ." and id_produto= " .$id_produto;
            $this->db->query($sqlRepoemEstoque);

            $sqlMudaStatusFilho = "update venda_filho set cancelado = 'S' where id_venda = " .$id ." and id_produto= " .$id_produto;
            $this->db->query($sqlMudaStatusFilho);
        };

        return TRUE;
    }





    public function buscaproduto ($id) {
        //$this->db->where('md5(id)',$id);
         //return $this->db->delete('vendas');
 
        $this->db->select('
            *
        ');
        $this->db->from('produtos');
        $this->db->limit(1);
        $this->db->where('id ='.$id);
        return $this->db->get('')->result();
         
     }




     public function buscaestoque ($id, $usuario) {

        $this->db->select('
            *
        ');
        $this->db->from('estoques');
        $this->db->limit(1);
        $this->db->where('id_produto ='.$id);
        $this->db->where('id_usuario ='.$usuario);
        return $this->db->get('')->result();
     }



    public function buscaestoquetemp ($id, $usuario) {
    //$this->db->where('md5(id)',$id);
        //return $this->db->delete('vendas');

    $this->db->select('
        sum(quantidade) as quantidadetemp
    ');
    $this->db->from('venda_filho_temp');
    $this->db->limit(1);
    $this->db->where('id_produto ='.$id);
    $this->db->where('id_usuario ='.$usuario);
    return $this->db->get('')->result();
    }


    public function gravaitemtemporario($id_produto, $usuario, $quantidade, $valor_unitario) {
        $valor_total = $quantidade * $valor_unitario;
        $sqlBaixa = "insert into venda_filho_temp (id, id_usuario, id_produto, quantidade, valor_unitario, valor_total) values (null, $usuario, $id_produto, $quantidade, '$valor_unitario','$valor_total')";
        $this->db->query($sqlBaixa);

        return TRUE;
    }


    public function zeraitemtemporario($usuario) {
        $sqlBaixa = "delete from venda_filho_temp where id_usuario = $usuario";
        $this->db->query($sqlBaixa);

        return TRUE;
    }


    
    public function busca_item_temporario($usuario) {
        //$this->db->where('md5(id)',$id);
         //return $this->db->delete('vendas');
 
        $this->db->select('
            produtos.nome,
            produtos.img,
            produtos.descricao,
            venda_filho_temp.*
            
        ');
        $this->db->from('venda_filho_temp');
        $this->db->join('produtos','produtos.id = venda_filho_temp.id_produto');
        $this->db->where('id_usuario ='.$usuario);
        return $this->db->get('')->result();
         
     }





     // Aqui inicializa a venda

     public function buscaItensAdicionadoTemp ($usuario) {
        //$this->db->where('md5(id)',$id);
         //return $this->db->delete('vendas');
 
        $this->db->select('
            count(quantidade) as quantidadetemp
        ');
        $this->db->from('venda_filho_temp');
        $this->db->limit(1);
        $this->db->where('id_usuario ='.$usuario);
        return $this->db->get('')->result();
     }



    
    public function somaValorVendaTemporario ($usuario) {
        //$this->db->where('md5(id)',$id);
            //return $this->db->delete('vendas');

        $this->db->select('
            sum(valor_total) as valor_total
        ');
        $this->db->from('venda_filho_temp');
        $this->db->limit(1);
        $this->db->where('id_usuario ='.$usuario);
        return $this->db->get('')->result();
    }


    
     
    //NOVO Adiciona no Banco uma nova venda
    public function adicionar_venda($valor_total, $usuario, $data, $observacoes, $forma_pagamento, $vendedor)
    {

        $armazena_vendas['id_usuario'] = $usuario;
        $armazena_vendas['data'] = $data;
        $armazena_vendas['valor_total'] = $valor_total;
        $armazena_vendas['observacoes'] = $observacoes;
        $armazena_vendas['meio_pagamento'] = $forma_pagamento;
        $armazena_vendas['vendedor'] = $vendedor;
        $this->db->insert('vendas', $armazena_vendas);

        $this->db->select('
            id
        ');
        $this->db->from('vendas');
        $this->db->where('id_usuario ='.$usuario);
        $this->db->order_by('vendas.id', 'DESC');
        $this->db->limit(1);
        $query_venda = $this->db->get('')->result();

        $id_venda = 0;
        foreach ($query_venda as $linhaquery) {
            $id_venda = $linhaquery->id;
        } 

        if($id_venda == 0) {
            return FALSE;
        } else {
            return $id_venda;
        }
    }


    public function busca_itens_vendidos_temporario ($usuario) {
        //$this->db->where('md5(id)',$id);
         //return $this->db->delete('vendas');
 
        $this->db->select('
            *
        ');
        $this->db->from('venda_filho_temp');
        $this->db->where('id_usuario ='.$usuario);
        return $this->db->get('')->result();
     }

    
    //adiciona venda filho
    public function adicionar_venda_filho($id_venda, $usuario)
    {
        
        $linhasestoquestemp = $this->vendasmodel->busca_itens_vendidos_temporario($usuario);
        foreach ($linhasestoquestemp as $linhaestoquetemp) {
            $quantidade = $linhaestoquetemp->quantidade;
            $id_produto = $linhaestoquetemp->id_produto;

            $armazena_vendas['id_venda'] = $id_venda;
            $armazena_vendas['id_produto'] = $id_produto;
            $armazena_vendas['quantidade'] = $quantidade;
            $armazena_vendas['valor_unitario'] = $linhaestoquetemp->valor_unitario;
            $armazena_vendas['valor_total'] = $linhaestoquetemp->valor_total;
            $this->db->insert('venda_filho', $armazena_vendas);

            $sqlBaixa = "update estoques set quantidade_atual = (quantidade_atual - " .$quantidade .") where id_usuario = " .$usuario ." and id_produto= " .$id_produto;
            $this->db->query($sqlBaixa);
        } 
   
    }


    public function deletaprodutotemporario($id_na_exclusao) {
        //$this->db->where('md5(id)',$id);
         //return $this->db->delete('vendas');
 
 
         $sqlUpdate = "delete from venda_filho_temp where id = " .$id_na_exclusao;
         $this->db->query($sqlUpdate);
 
         return TRUE;
     }


    // Lista valores de vendas que ainda nao foram faturados
    public function listar_valor_em_aberto ($usuario) {
        //$this->db->where('md5(id)',$id);
            //return $this->db->delete('vendas');
        $nao = 'N';
        $this->db->select('
            sum(valor_total) as valor_total
        ');
        $this->db->from('vendas');
        $this->db->limit(1);
        $this->db->where('id_usuario',$usuario);
        $this->db->where('cancelado',$nao);
        $this->db->where('acertado',$nao);
        return $this->db->get('')->result();
    }

    // Lista valores de vendas que ainda nao foram faturados
    public function listar_valor_em_aberto_geral () {
        //$this->db->where('md5(id)',$id);
            //return $this->db->delete('vendas');
        $nao = 'N';
        $this->db->select('
            sum(valor_total) as valor_total
        ');
        $this->db->from('vendas');
        $this->db->limit(1);
        $this->db->where('cancelado',$nao);
        $this->db->where('acertado','N');
        return $this->db->get('')->result();
    }

    //Lista Valores de vendas que foram faturados e ainda foram pagos
    public function listar_fatura_aberta ($usuario) {
        //$this->db->where('md5(id)',$id);
            //return $this->db->delete('vendas');
        $nao = 'N';
        $sim = 'S';
        $this->db->select('
            sum(valor_total) as valor_total
        ');
        $this->db->from('vendas');
        $this->db->limit(1);
        $this->db->where('id_usuario',$usuario);
        $this->db->where('cancelado',$nao);
        $this->db->where('acertado',$sim);
        return $this->db->get('')->result();
    }


    //Listo o nome do usuário no titulo do admin
    public function listar_nome_usuario_admin($id){
        $this->db->select('
            usuarios.nome,
            usuarios.id'
        );
        $this->db->from('usuarios');
        $this->db->where('id ='.$id);
        return $this->db->get('')->result();
    }


    public function salvar_vendas_acertadas_academia_admin($itens_confirmar) {
        
        foreach ($itens_confirmar as $item)  {
            $salvaPagamento = "update vendas set acertado = 'P' where id = " .$item;
            $this->db->query($salvaPagamento);
        };
        return TRUE;

    }






}