<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Estoque_model extends CI_Model {

    public $id_usuario;
    public $id_produtos;
    public $nome;
    public $valor;
    public $img;
    public $id;
    public $quantidade_atual;
    public $quantidade_contratada;
    public $ultima_atualizacao;


    public function __construct(){
        parent::__construct();
    }

    public function listar_estoque($id){
        $this->db->select('
            produtos.id as idprodutos,
            produtos.nome,
            produtos.valor,
            produtos.descricao,
            produtos.img,
            estoques.id_usuario,
            estoques.id,
            estoques.id_produto,
            estoques.quantidade_atual,
            estoques.quantidade_contratada,
            estoques.quantidade_acerto,
            estoques.ultima_atualizacao,
            sum(estoques.quantidade_acerto * produtos.valor) as valor_acerto,
            sum(estoques.quantidade_atual * produtos.valor) as valor_atual
            '
        );
        $this->db->from('estoques');
        $this->db->join('produtos','produtos.id = estoques.id_produto');
        $this->db->order_by('produtos.nome','ASC');
        $this->db->group_by('produtos.id');
        $this->db->group_by('estoques.id');
        $this->db->where('id_usuario ='.$id);
        return $this->db->get('')->result();
    }



    public function listar_somas_estoque($id){
        $this->db->select('
            sum(estoques.quantidade_atual) as quantidade_atual,
            sum(estoques.quantidade_acerto) as quantidade_acerto,
            '
        );
        $this->db->from('estoques');
        $this->db->join('produtos','produtos.id = estoques.id_produto');
        $this->db->order_by('produtos.nome','ASC');

        $this->db->where('id_usuario ='.$id);
        return $this->db->get('')->result();
    }

    //Soma dos valores de vendas totais exibidos na pagina de produtos
    public function listar_soma_vendas_produto($id, $produto, $periodo) {
        $this->db->select('
            sum(quantidade) as quantidade,
            sum(venda_filho.valor_total) as valor_total_somado,
        ');
        $this->db->from('venda_filho');
        $this->db->join('vendas', 'venda_filho.id_venda = vendas.id');
        $this->db->join('produtos', 'venda_filho.id_produto = produtos.id');
        $this->db->where('vendas.acertado','N');
        $this->db->where('venda_filho.cancelado','N');
        $this->db->where('id_usuario ='.$id);
        if ($periodo > 0) {
            $data = date("Y-m-d");
            $where = "data BETWEEN (DATE_ADD('".$data."', INTERVAL -".$periodo." DAY)) AND (DATE_ADD('".$data."', INTERVAL 1 DAY))";
            $this->db->where($where);
        }
        if (!$produto == NULL) {
            $where = "produtos.nome LIKE '%".$produto."%'";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }


    //Soma dos valores de vendas totais exibidos na pagina de produtos
    public function listar_soma_estoques_produto($id, $produto) {
        $this->db->select('
            sum(estoques.quantidade_atual * produtos.valor) as valor_total_somado,
            sum(estoques.quantidade_atual) as quantidade,
        ');
        $this->db->from('estoques');
        $this->db->join('produtos','produtos.id = estoques.id_produto');
        $this->db->where('id_usuario ='.$id);
        if (!$produto == NULL) {
            $where = "produtos.nome LIKE '%".$produto."%'";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();


    }

    


    public function listar_estoque_admin($id){
        $this->db->select('
            usuarios.nome as nomeusuario,
            produtos.id as idprodutos,
            produtos.nome,
            produtos.valor,
            produtos.descricao,
            produtos.img,
            estoques.id_usuario,
            estoques.id,
            estoques.id_produto,
            estoques.quantidade_atual,
            estoques.quantidade_contratada,
            estoques.quantidade_acerto,
            estoques.ultima_atualizacao'
        );
        $this->db->from('estoques');
        $this->db->join('produtos','produtos.id = estoques.id_produto');
        $this->db->join('usuarios','usuarios.id = estoques.id_usuario');
        $this->db->order_by('produtos.nome','ASC');
        $this->db->where('id_usuario ='.$id);
        return $this->db->get('')->result();
    }


    public function listar_nome_usuario_admin($id){
        $this->db->select('
            usuarios.nome'
        );
        $this->db->from('usuarios');
        $this->db->where('id ='.$id);
        return $this->db->get('')->result();
    }


    public function exibe_detalhes_da_edicao_de_estoque($id){
        $this->db->select('
            usuarios.nome as nomeusuario,
            produtos.id as idprodutos,
            produtos.nome,
            produtos.valor,
            produtos.descricao,
            produtos.img,
            estoques.id_usuario,
            estoques.id,
            estoques.id_produto,
            estoques.quantidade_contratada'
        );
        $this->db->from('estoques');
        $this->db->join('produtos','produtos.id = estoques.id_produto');
        $this->db->join('usuarios','usuarios.id = estoques.id_usuario');
        $this->db->order_by('produtos.nome','ASC');
        $this->db->where('estoques.id ='.$id);
        return $this->db->get('')->result();
    }


    public function atualiza_quantidade_contratada($idestoque, $quantidade) {
        $sqlRepoemEstoque = "update estoques set quantidade_contratada = " .$quantidade ." where id = " .$idestoque;
        $this->db->query($sqlRepoemEstoque);

        return true;

    }



    
    



//echo
}


