<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Estatisticas_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }




    public function listar_produtos_admin ($produto) { 
        $this->db->select('
            produtos.id,
            produtos.nome,
            produtos.valor,
            produtos.descricao,
            produtos.img
        ');
        $this->db->from('produtos');
        if (!$produto == NULL) {
            $where = "nome LIKE '%".$produto."%'";
            $this->db->where($where);
        }
        return $this->db->get('')->result();
    }



    public function listar_vendas_produto($id, $periodo) {
        $this->db->select('
            sum(quantidade) as quantidade,
            sum(venda_filho.valor_total) as valor_total_somado,
        ');
        $this->db->from('venda_filho');
        $this->db->join('vendas', 'venda_filho.id_venda = vendas.id');
        $this->db->where('id_produto ='.$id);
        $this->db->where('venda_filho.cancelado','N');
        $this->db->where('vendas.acertado','N');
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();

    }

    //Soma dos valores de vendas totais exibidos na pagina de produtos
    public function listar_soma_vendas_produto($produto, $periodo) {
        $this->db->select('
            sum(quantidade) as quantidade,
            sum(venda_filho.valor_total) as valor_total_somado,
        ');
        $this->db->from('venda_filho');
        $this->db->join('vendas', 'venda_filho.id_venda = vendas.id');
        $this->db->join('produtos', 'venda_filho.id_produto = produtos.id');
        $this->db->where('vendas.acertado','N');
        $this->db->where('venda_filho.cancelado','N');
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        if (!$produto == NULL) {
            $where = "produtos.nome LIKE '%".$produto."%'";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }



    public function detalhe_produto_admin($id) {
        $this->db->select('
            produtos.id,
            produtos.nome,
            produtos.descricao,
            produtos.img,
            produtos.valor

        ');
        $this->db->from('produtos');
        $this->db->where('id ='.$id);
        $this->db->limit(1);
        return $this->db->get('')->result();

    }


    public function estoques_produto_admin($id, $academia, $periodo) {
        $this->db->select('
            estoques.id,
            estoques.id_usuario,
            estoques.id_produto,
            estoques.quantidade_acerto,
            estoques.quantidade_atual,
            usuarios.nome
        ');
        $this->db->from('estoques');
        $this->db->join('usuarios', 'estoques.id_usuario = usuarios.id');
        $this->db->where('estoques.id_produto ='.$id);
        if (!$academia == NULL) {
            $where = "usuarios.nome LIKE '%".$academia."%'";
            $this->db->where($where);
        }
        return $this->db->get('')->result();
    }


    public function soma_estoques_produto_admin($id, $academia, $periodo) {
        $this->db->select('
            sum(quantidade_atual) as quantidade_atual
        ');
        $this->db->from('estoques');
        $this->db->join('usuarios', 'estoques.id_usuario = usuarios.id');
        $this->db->where('estoques.id_produto ='.$id);
        if (!$academia == NULL) {
            $where = "usuarios.nome LIKE '%".$academia."%'";
            $this->db->where($where);
        }
        return $this->db->get('')->result();
    }



    public function listar_vendas_academia($id_produto, $id_usuario, $periodo) {
        $this->db->select('
            sum(quantidade) as quantidade,
            sum(venda_filho.valor_total) as valor_total_somado,
        ');
        $this->db->from('venda_filho');
        $this->db->join('vendas', 'venda_filho.id_venda = vendas.id');
        $this->db->where('id_produto ='.$id_produto);
        $this->db->where('vendas.id_usuario ='.$id_usuario);
        $this->db->where('venda_filho.cancelado','N');
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }



    public function listar_soma_vendas_produto_detalhe($id_produto, $academia, $periodo) {
        $this->db->select('
            sum(quantidade) as quantidade,
            sum(venda_filho.valor_total) as valor_total_somado,
        ');
        $this->db->from('venda_filho');
        $this->db->join('vendas', 'venda_filho.id_venda = vendas.id');
        $this->db->join('usuarios', 'vendas.id_usuario = usuarios.id');
        $this->db->where('venda_filho.id_produto', $id_produto);
        $this->db->where('venda_filho.cancelado','N');
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        if (!$academia == NULL) {
            $where = "usuarios.nome LIKE '%".$academia."%'";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }


    //Soma do numero total de vendas
    public function pag_estatistica_numero_total_venda($periodo) {
        $this->db->select('
            count(id) as numero_total_vendas
        ');
        $this->db->from('vendas');
        $this->db->where('cancelado', 'N');
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }


    //Soma do numero total de vendas
    public function pag_estatistica_faturamento($periodo) {
        $this->db->select('
            sum(vendas.valor_total) as valor_total_somado,
        ');
        $this->db->from('vendas');
        $this->db->where('cancelado', 'N');
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }

    //Soma do numero total de vendas
    public function pag_estatistica_total_receber($periodo) {
        $this->db->select('
            sum(vendas.valor_total) as valor_total_somado,
        ');
        $this->db->from('vendas');
        $this->db->where('acertado', 'N');
        $this->db->where('cancelado', 'N');
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }


    //Soma do numero total de acerto
    public function pag_estatistica_total_acerto($periodo) {
        $this->db->select('
            sum(ctreceber.vrdoc) as valor_total_somado,
        ');
        $this->db->from('ctreceber');

        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "dataemis BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }
    

    //Melhores Vendedores
    public function pag_estatistica_melhores_vendedores($periodo) {
        $this->db->select('
            sum(vendas.valor_total) as valor_total_somado,
            usuarios.nome

        ');
        $this->db->from('vendas');
        $this->db->where('cancelado', 'N');
        $this->db->join('usuarios', 'usuarios.id = vendas.id_usuario');
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->group_by("id_usuario");
        $this->db->order_by('valor_total_somado', 'DESC');
        $this->db->limit(6);
        return $this->db->get('')->result();
    }



    //Produtos mais vendidos
    public function pag_estatistica_mais_vendidos($periodo) {
        $this->db->select('          
            sum(venda_filho.valor_total) as valor_total_somado,
            sum(quantidade) as quantidade_somada,
            produtos.nome

        ');
        $this->db->from('venda_filho');
        $this->db->where('venda_filho.cancelado', 'N');
        $this->db->join('produtos', 'produtos.id = venda_filho.id_produto');
        $this->db->join('vendas', 'vendas.id = venda_filho.id_venda');
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->group_by("id_produto");
        $this->db->order_by('quantidade_somada', 'DESC');
        $this->db->limit(6);
        return $this->db->get('')->result();
    }

    //Aqui eu lista a quantidade produtos em estoque e o valor disso, para exibir na pagina de produtos no admin
    public function listar_estoques_produto($id) {
        $this->db->select('
            sum(estoques.quantidade_atual * produtos.valor) as valor_total_somado,
            sum(estoques.quantidade_atual) as quantidade,
        ');
        $this->db->from('estoques');
        $this->db->join('produtos','produtos.id = estoques.id_produto');
        $this->db->where('id_produto ='.$id);
        $this->db->limit(1);
        return $this->db->get('')->result();
    }

    //Soma dos valores de vendas totais exibidos na pagina de produtos
    public function listar_soma_estoques_produto($produto) {
        $this->db->select('
            sum(estoques.quantidade_atual * produtos.valor) as valor_total_somado,
            sum(estoques.quantidade_atual) as quantidade,
        ');
        $this->db->from('estoques');
        $this->db->join('produtos','produtos.id = estoques.id_produto');
        if (!$produto == NULL) {
            $where = "produtos.nome LIKE '%".$produto."%'";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();

    }




    //
    //
    //Fronend - Página acaemia
    //
    //


    //Soma do numero total de vendas
    public function dashboard_academia_numero_total_venda($periodo, $id_usuario) {
        $this->db->select('
            count(id) as numero_total_vendas
        ');
        $this->db->from('vendas');
        $this->db->where('cancelado', 'N');
        $this->db->where('vendas.id_usuario ='.$id_usuario);
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }


    //Soma do numero total do faturamento
    public function dashboard_academia_faturamento($periodo, $id_usuario) {
        $this->db->select('
            sum(vendas.valor_total) as valor_total_somado,
        ');
        $this->db->from('vendas');
        $this->db->where('cancelado', 'N');
        $this->db->where('acertado', 'N');
        $this->db->where('vendas.id_usuario ='.$id_usuario);
        if (!$periodo == NULL) {
            
            $periodo = explode(" - ", $periodo);
  
            //converto o formato da data de inicio
            $date = str_replace('/', '-', $periodo[0] );
            $inicio = date("Y-m-d", strtotime($date));

            //converto o formato da data de fim
            $date = str_replace('/', '-', $periodo[1] );
            $fim = date("Y-m-d", strtotime($date));

            $where = "data BETWEEN '".$inicio."' AND '".$fim."' ";
            $this->db->where($where);
        }
        $this->db->limit(1);
        return $this->db->get('')->result();
    }

    //Soma do numero total de vendas
    public function dashboard_total_acerto_aberto($id_usuario) {
        $this->db->select('
            sum(ctreceber.vrdoc) as valor_total_somado,
        ');
        $this->db->from('ctreceber');
        $this->db->where_not_in('situacao', 'Q');
        $this->db->where('idusuario', $id_usuario);
        $this->db->limit(1);
        return $this->db->get('')->result();
    }





}