<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mensagens extends CI_Controller {


	public function __construct(){
        parent::__construct();
        //Aqui eu valido se o usário está logado,
        // se nao estiver, redireciona pro login
        if(!$this->session->userdata('logado')){
            redirect(base_url(''));
        }

        $id_usuario = $this->session->userdata('userlogado')->id;
        $this->load->model('mensagens_model','mensagensmodel');
    }

    public function index()
	{
        $dados['titulo'] = 'Mensagens';

        $id_usuario = $this->session->userdata('userlogado')->id;
        $this->mensagens = $this->mensagensmodel->listar_mensagens_usuario($id_usuario);

        $dados['mensagens'] = $this->mensagens;


		$this->load->view('template/html-header',$dados);
		$this->load->view('template/header');
		$this->load->view('template/aside');
		$this->load->view('conteudo/mensagens');
		$this->load->view('template/footer');
        $this->load->view('conteudo/mensagens-extra');
		$this->load->view('template/html-footer');
    }



    public function visualizar($id) {
        $id_usuario = $this->session->userdata('userlogado')->id;
        $this->mensagens = $this->mensagensmodel->visualizar_mensagem($id, $id_usuario);
        $dados['mensagens'] = $this->mensagens;
        $dados['titulo'] = 'Mensagens';


		$this->load->view('template/html-header',$dados);
		$this->load->view('template/header');
		$this->load->view('template/aside');
		$this->load->view('conteudo/visualizar-mensagen');
		$this->load->view('template/footer');
        $this->load->view('conteudo/mensagens-extra');
		$this->load->view('template/html-footer');
    }
    

}
