<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inicio extends CI_Controller {


    public function __construct(){
        parent::__construct();

        //Aqui eu valido se o usário está logado,
        // se nao estiver, redireciona pro login
        if(!$this->session->userdata('logado')){
            redirect(base_url(''));
        }
        $this->load->model('mensagens_model','mensagensmodel');
        $this->load->model('estatisticas_model','estatisticasmodel'); 
    }

	public function index()
	{
		$dados['titulo'] = 'Início';
		$dados['nomeacademia'] = 'Prolife Gym';

    $vendedor = $this->input->get('vendedor');
    $periodo = $this->input->get('periodo');
    $status = $this->input->get('status');

        //pego o id do usuário logado, incializo o model, executo
        $id_usuario = $this->session->userdata('userlogado')->id;
        $this->load->model('vendas_model','vendasmodel');
        $this->vendas = $this->vendasmodel->listar_vendas_home_usuario($id_usuario);

        $dados['id_usuario'] = $this->session->userdata('userlogado')->id;

        $dados['vendas'] = $this->vendas;


		$this->load->view('template/html-header',$dados);
		$this->load->view('template/header');
		$this->load->view('template/aside');
		$this->load->view('conteudo/dashboard');
		$this->load->view('template/footer');
        $this->load->view('conteudo/dashboard-extra');
		$this->load->view('template/html-footer');
    }


    public function dashboard_academia_numero_total_venda() {
        $periodo = $this->input->post('periodo');
        $id_usuario = $this->input->post('id_usuario');
        $dados['titulo'] = 'Número Total de Vendas';
        $dados['resultado_total_vendas'] = $this->estatisticasmodel->dashboard_academia_numero_total_venda($periodo, $id_usuario);
        $this->load->view('conteudo/estatisticas/resultado-total',$dados);
    }

    public function dashboard_academia_faturamento_total() {
        $periodo = $this->input->post('periodo');
        $id_usuario = $this->input->post('id_usuario');
        $dados['titulo'] = 'Faturamento Total';
        $dados['faturamento'] = $this->estatisticasmodel->dashboard_academia_faturamento($periodo, $id_usuario);
        $this->load->view('conteudo/estatisticas/resultado-faturamento',$dados);
    }

}
