<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Estoque extends CI_Controller {


	public function __construct(){
        parent::__construct();
        //Aqui eu valido se o usário está logado,
        // se nao estiver, redireciona pro login
        if(!$this->session->userdata('logado')){
            redirect(base_url(''));
        }

        $id_usuario = $this->session->userdata('userlogado')->id;
        $this->load->model('mensagens_model','mensagensmodel');
        $this->load->model('estoque_model','modelestoque');
        $this->estoque = $this->modelestoque->listar_estoque($id_usuario);
    }

    public function index()
	{
		$dados['titulo'] = 'Estoque';
        $dados['estoques'] = $this->estoque;


		$this->load->view('template/html-header',$dados);
		$this->load->view('template/header');
		$this->load->view('template/aside');
		$this->load->view('conteudo/estoque');
		$this->load->view('template/footer');
        $this->load->view('conteudo/estoque-extra');
		$this->load->view('template/html-footer');
    }
    
    public function imprimir()
	{
		$dados['titulo'] = 'Estoque';
		$dados['nomeacademia'] = 'Prolife Gym';
        $dados['estoques'] = $this->estoque;


		$this->load->view('conteudo/estoque-imprimir',$dados);

	}
}
