<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Adminvendas extends CI_Controller {

    public function __construct(){
        parent::__construct();

        //Aqui eu valido se o usário está logado,
        // se nao estiver, redireciona pro login
        if(!$this->session->userdata('logadoadmin')){
            redirect(base_url(''));
        }
        //pego o id do usuário logado, incializo o model, executo
        $id_usuario = $this->session->userdata('userlogadoadmin')->id;
        $this->load->model('vendas_model','vendasmodel');        
    }




    //Pagina com as vendas em geral
	public function index()
	{   
        $academia = $this->input->get('academia');
        $periodo = $this->input->get('periodo');
        $cancelado = $this->input->get('cancelado');


        $dados['titulo'] = 'Vendas';
        $this->vendas = $this->vendasmodel->listar_vendas_admin($academia, $periodo, $cancelado);
        $dados['vendas'] = $this->vendas;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/vendas');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/relatorio-vendas-extra');
		$this->load->view('admin/template/html-footer');
    }
    

    //Lista as vendas por academias
    public function academia($id)
	{
        $periodo = $this->input->get('periodo');
        $cancelado = $this->input->get('cancelado');

        $dados['titulo'] = 'Vendas por Academia';
        $this->vendas = $this->vendasmodel->listar_vendas_academia_admin($id, $periodo, $cancelado);
        $dados['vendas'] = $this->vendas;

        $this->nomeacademia = $this->vendasmodel->listar_nome_usuario_admin($id);
        $dados['nomeacademia'] = $this->nomeacademia;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/vendas-academia');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/vendas-extra');
		$this->load->view('admin/template/html-footer');
    }

    
    //Tela para confirmação dos pedidos com o status S = Faturados SIM (aguardando pagamento)
    public function confirmaPagamento($id)
	{
        $dados['titulo'] = 'Confirmar Pagamento';
        $this->vendas = $this->vendasmodel->listar_vendas_acertar_academia_admin($id);
        $dados['vendas'] = $this->vendas;

        $this->nomeacademia = $this->vendasmodel->listar_nome_usuario_admin($id);
        $dados['nomeacademia'] = $this->nomeacademia;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/confirmar-vendas-academia');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/vendas-extra');
		$this->load->view('admin/template/html-footer');
    }
    



    //Salva o pagamento confirmado pela administração
    public function salvaPagamento()
	{
        $itens_confirmar = $this->input->post('item-confirmar');
        $id = $this->input->post('id-academia');

        if ($itens_confirmar == null) {
            //set_flashdata é um metodo pra salvar um dado na seção por tempo limitado apenas para o redirecionamento
            $this->session->set_flashdata('mensagem',1);
            redirect(base_url('').'admin/vendas/academia/confirma-pagamento/'.$id);
        }
        
        
        if ($this->vendasmodel->salvar_vendas_acertadas_academia_admin($itens_confirmar)) {
            $this->session->set_flashdata('mensagem',1);
            redirect(base_url('').'admin/vendas/academia/'.$id);
        }else{
            echo "Houve um erro";
            return;
        }
        

        
	}


}
