<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Adminmensagens extends CI_Controller {


    public function __construct(){
        parent::__construct();

        if(!$this->session->userdata('logadoadmin')){
            redirect(base_url('admin'));
        }

        $this->load->model('mensagens_model','mensagensmodel');
    }


    //Listagem de Mensagens
	public function index()
	{
        $dados['titulo'] = 'Mensagens';
        
        $this->mensagens = $this->mensagensmodel->listar_mensagens();
        $dados['mensagens'] = $this->mensagens;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/mensagens');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/mensagens-extra');
		$this->load->view('admin/template/html-footer');
    }
    

    //Pagina de criação de mensagens
    public function nova()
	{
        $dados['titulo'] = 'Nova Mensagem';
        $this->usuarios = $this->mensagensmodel->listar_usuarios();
        
        $dados['usuarios'] = $this->usuarios;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/mensagens-nova');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/mensagens-nova-extra');
		$this->load->view('admin/template/html-footer');
    }
    
    public function publicar_mensagem() {
        $titulo = $this->input->post('titulo');
        $mensagem = $this->input->post('mensagem');
        $status = '1';
        //$status = $this->input->post('status');
        $enviar_para = $this->input->post('enviar-para');
        $usuario = $this->input->post('usuario');

        $this->mensagensmodel->publica_mensagem($titulo, $mensagem, $status, $enviar_para, $usuario);
    }



    public function excluir_mensagem($id) {
        if ($this->mensagensmodel->deleta_mensagem($id)) {
            $this->session->set_flashdata('mensagem','excluiu');
            redirect(base_url('admin/mensagens'));
        }else{
            echo "Houve um erro";
            //redirect(base_url('vendas'));
        }
    }

    /*  Recurso desativado
    //Pagina de criação de mensagens
    public function editar_mensagem($id)
	{
        $dados['titulo'] = 'Nova Mensagem';
        $this->mensagem = $this->mensagensmodel->editar_mensagem_admin($id);
        
        $dados['mensagem'] = $this->mensagem;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/mensagens-editar');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/mensagens-nova-extra');
		$this->load->view('admin/template/html-footer');
    }
    */
}
