<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Adminestatisticas extends CI_Controller {

    public function __construct(){
        parent::__construct();

        //Aqui eu valido se o usário está logado,
        // se nao estiver, redireciona pro login
        if(!$this->session->userdata('logadoadmin')){
            redirect(base_url('admin'));
        }
        //pego o id do usuário logado, incializo o model, executo
        //$id_usuario = $this->session->userdata('logadoadmin')->id;
        $this->load->model('vendas_model','vendasmodel'); 
        $this->load->model('estatisticas_model','estatisticasmodel');         
    }




    //Pagina com as estatiscas em geral
	public function index()
	{   
        $academia = $this->input->get('academia');
        $periodo = $this->input->get('periodo');
        $cancelado = $this->input->get('cancelado');

        $dados['titulo'] = 'Estatisticas';
        $this->vendas = $this->vendasmodel->listar_vendas_admin($academia, $periodo, $cancelado);
        $dados['vendas'] = $this->vendas;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/estatisticas');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/estatisticas-geral-extra');
		$this->load->view('admin/template/html-footer');
    }




    //Pagina com as estatiscas de produtos
	public function produtos()
	{   
        $produto = $this->input->get('produto');

        $dados['titulo'] = 'Estatisticas Por Produtos';
        $this->produtos = $this->estatisticasmodel->listar_produtos_admin($produto);
        $dados['produtos'] = $this->produtos;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/estatisticas-produtos');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/estatisticas-produtos-extra');
		$this->load->view('admin/template/html-footer');
    }


    //Pagina com os detalhes do produto + a lista de academias que trabalham com ele 
	public function detalhesProduto($id)
	{   

        $academia = $this->input->get('academia');
        $periodo = $this->input->get('periodo');

        $dados['titulo'] = 'Estatisticas Por Produtos';
        $this->produto = $this->estatisticasmodel->detalhe_produto_admin($id);
        $dados['produto'] = $this->produto;

        $this->estoque = $this->estatisticasmodel->estoques_produto_admin($id, $academia, $periodo);
        $dados['estoque'] = $this->estoque;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/estatisticas-detalhes-produtos');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/estatisticas-produtos-extra');
		$this->load->view('admin/template/html-footer');
    }


    


}
