<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Adminacertos extends CI_Controller {


	public function __construct(){
        parent::__construct();
        //Aqui eu valido se o usário está logado,
        // se nao estiver, redireciona pro login
        if(!$this->session->userdata('logadoadmin')){
            redirect(base_url(''));
        }

        //$id_usuario = $this->session->userdata('userlogadoadmin')->id;
        $this->load->model('acertos_model','modelsacertos');
        
    }

    public function index()
	{
		$dados['titulo'] = 'Acertos';
        
        $academia = $this->input->get('academia');
        $numdoc = $this->input->get('numdoc');
        $emissao = $this->input->get('emissao');
        $vencimento = $this->input->get('vencimento');
        $status = $this->input->get('status');
        

        $this->acertos = $this->modelsacertos->listar_acertos_admin($academia, $numdoc, $emissao, $vencimento, $status);
        $dados['acertos'] = $this->acertos;

        $this->somatotal = $this->modelsacertos->listar_soma_acertos_admin($academia, $numdoc, $emissao, $vencimento, $status);
        $dados['somatotal'] = $this->somatotal;


		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/acertos');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/acertos-extra');
		$this->load->view('admin/template/html-footer');
    }


    public function academia($id)
	{
        $dados['titulo'] = 'Acertos';
        $numdoc = $this->input->get('numdoc');
        $emissao = $this->input->get('emissao');
        $vencimento = $this->input->get('vencimento');
        $status = $this->input->get('status');
        
        $this->acertos = $this->modelsacertos->listar_acertos_usuario($id, $numdoc, $emissao, $vencimento, $status);
        $dados['acertos'] = $this->acertos;

        $this->somatotal = $this->modelsacertos->listar_soma_acertos_usuario($id, $numdoc, $emissao, $vencimento, $status);
        $dados['somatotal'] = $this->somatotal;

		$this->load->view('admin/template/html-header',$dados);
		$this->load->view('admin/template/header');
		$this->load->view('admin/template/aside');
		$this->load->view('admin/conteudo/acertos-academia');
		$this->load->view('admin/template/footer');
        $this->load->view('admin/conteudo/acertos-extra');
		$this->load->view('admin/template/html-footer');
    }


}
