<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Acertos extends CI_Controller {


	public function __construct(){
        parent::__construct();
        //Aqui eu valido se o usário está logado,
        // se nao estiver, redireciona pro login
        if(!$this->session->userdata('logado')){
            redirect(base_url(''));
        }

        //$id_usuario = $this->session->userdata('userlogadoadmin')->id;
        $this->load->model('acertos_model','modelsacertos');
        $this->load->model('mensagens_model','mensagensmodel');
        
    }

    public function index()
	{
		$dados['titulo'] = 'Acertos';
        $id_usuario = $this->session->userdata('userlogado')->id;
        $numdoc = $this->input->get('numdoc');
        $emissao = $this->input->get('emissao');
        $vencimento = $this->input->get('vencimento');
        $status = $this->input->get('status');

        $this->acertos = $this->modelsacertos->listar_acertos_usuario($id_usuario, $numdoc, $emissao, $vencimento, $status);
        $dados['acertos'] = $this->acertos;

        $this->somatotal = $this->modelsacertos->listar_soma_acertos_usuario($id_usuario, $numdoc, $emissao, $vencimento, $status);
        $dados['somatotal'] = $this->somatotal;

		$this->load->view('template/html-header',$dados);
		$this->load->view('template/header');
		$this->load->view('template/aside');
		$this->load->view('conteudo/acertos');
		$this->load->view('template/footer');
        $this->load->view('conteudo/acertos-extra');
		$this->load->view('template/html-footer');
    }


}
