<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
//$route['vendas/adiciona_temporario'] = 'vendas/adicionatemporario';
//$route['teste-categoria'] = 'categorias';
//$route['admin/inicio'] = 'admininicio';



//frontend
$route['404_override'] = 'paginanaoencontrada';
$route['translate_uri_dashes'] = FALSE;

$route['default_controller'] = 'acesso';
$route['inicio'] = 'inicio';
$route['estoque'] = 'estoque';
$route['vendas'] = 'vendas';

$route['vendas/nova-venda'] = 'vendas/nova';

$route['mensagens'] = 'mensagens';

$route['acertos'] = 'acertos';



//admin
$route['admin'] = 'adminacesso';
$route['admin/inicio'] = 'adminestatisticas';
$route['admin/vendas'] = 'adminvendas';
$route['admin/vendas/academia/(:num)'] = 'adminvendas/academia/$1';
$route['admin/vendas/academia/confirma-pagamento/(:num)'] = 'adminvendas/confirmaPagamento/$1';
$route['admin/vendas/academia/salvar-confirmacao'] = 'adminvendas/salvaPagamento';
$route['admin/estoque/academia/(:num)'] = 'adminestoque/academia/$1';
$route['admin/estoque/imprimir/(:num)'] = 'adminestoque/imprimir/$1';
$route['admin/estoque/academia/editor/(:num)'] = 'adminestoque/editor/$1';
$route['admin/estoque/academia/salvar'] = 'adminestoque/salva_edicao_estoque/$1';
$route['admin/academias'] = 'adminacademias';
$route['admin/estatisticas/produtos'] = 'adminestatisticas/produtos';
$route['admin/estatisticas/produtos/detalhe/(:num)'] = 'adminestatisticas/detalhesProduto/$1';

$route['admin/mensagens'] = 'Adminmensagens';
$route['admin/mensagens/nova'] = 'Adminmensagens/nova';
$route['admin/mensagens/editar/(:num)'] = 'Adminmensagens/editar_mensagem/$1';
$route['admin/mensagens/publicar-mensagem'] = 'Adminmensagens/publicar_mensagem';




$route['admin/acertos'] = 'Adminacertos';
$route['admin/acertos/academia/(:num)'] = 'Adminacertos/academia/$1';